----------------------------------------------------------------------------------------------------
-- SeasonsAvailabilityCheck
----------------------------------------------------------------------------------------------------
-- Purpose:  Removes Seasons-dependend store items from the store if Seasons is not available.
--
-- Copyright (c) Realismus Modding, 2019
----------------------------------------------------------------------------------------------------

local modDirectory = g_currentModDirectory

-- Active test: needed for console version where the code is always sourced.
function isActive()
    if GS_IS_CONSOLE_VERSION and not g_isDevelopmentConsoleScriptModTesting then
        return g_modIsLoaded["FS19_IFA_W50_WB_console"]
    end

    -- Normally this code never runs if Seasons was not active. However, in development mode
    -- this might not always hold true.
    return g_modIsLoaded["FS19_IFA_W50_WB"]
end

function isSeasonsActive()
    -- Might not be set at this point
    if g_seasons ~= nil then
        return true
    end

    if GS_IS_CONSOLE_VERSION then
        return g_modIsLoaded["FS19_RM_Seasons_console"]
    end

    return g_modIsLoaded["FS19_RM_Seasons"]
end

function ignoreStoreItems(self, superFunc, xmlFilename, baseDir, ...)
    -- Do not load the salt sprayer
    if isActive() and not isSeasonsActive() and baseDir == modDirectory and 
		(xmlFilename == "Spreader_D035_salt.xml" or xmlFilename == "Spreader_D035_seasons.xml") 
	then
        log("Warning: Seasons is missing. Salt spreader version of Fortschritt D035 will be removed from the store.")
        return nil
    --elseif isActive() and isSeasonsActive() and baseDir == modDirectory and xmlFilename == "Spreader_D035.xml" then
        --log("Warning: Seasons is used. Load only seasons version of Fortschritt D035 into store.")
        --return nil
	end

    return superFunc(self, xmlFilename, baseDir, ...)
end

StoreManager.loadItem = Utils.overwrittenFunction(StoreManager.loadItem, ignoreStoreItems)
