--[[
Interface: 1.7.1.0 b10490

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 12.11.2018

History:
V 1.0.1.0 @ 07.09.2019 - Add support for hand 'poseId'.
V 1.0.2.0 @ 14.01.2021 - Improved features and simplified some commands, printing to XML provides more data.

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


UP_Creator = {}
local UP_Creator_mt = Class(UP_Creator)

-- Use my own 'keyEvent' so no inputBindings need to be created for these functions.
-- Code could be improved but I am a little time poor and works well for its purpose. Adding to it since 17 has not helped.
UP_Creator.inputKeys = {
    [270] = "NUM+",
    [269] = "NUM-",
    [260] = "NUM_LEFT",
    [262] = "NUM_RIGHT",
    [264] = "NUM_UP",
    [258] = "NUM_DOWN",
    [265] = "NUMPAD_9",
    [263] = "NUMPAD_7",
    [261] = "NUMPAD_5",
    [256] = "NUMPAD_0",
    [268] = "NUMPAD_MULTIPLY",
    [267] = "NUMPAD_DIVIDE",
    [266] = "NUMPAD_PERIOD"
}

UP_Creator.poseIdToIndex = {
    ["narrowFingers"] = 1,
    ["wideFingers"] = 2,
    ["flatFingers"] = 3
}

UP_Creator.poseIndexToId = {
    "narrowFingers",
    "wideFingers",
    "flatFingers"
}

UP_Creator.activeInputKeys = {}
UP_Creator.activeInputKeysCounter = {}

UP_Creator.debugColourPink = {1, 0, 1}
UP_Creator.debugColourBlue = {0, 1, 1}

function UP_Creator:new()
    if g_universalPassenger == nil or g_universalPassenger.creator ~= nil then
        return
    end

    local self = setmetatable({}, UP_Creator_mt)

    self.isDev = false
    self.listActive = false
    self.infoActive = false

    self.enableOutdoorSoundControls = false
    self.enableExitPointControls = true

    self.active = false
    self.firstTimeRun = true
    self.charMovementActive = false
    self.actionEventsRegistered = false

    self.getCameraRotationFromI3D = false -- Use the rotation of the outside camera node to set the outside passenger camera. Not needed!

    return self
end

function UP_Creator:load()
    addConsoleCommand("upEnablePassengerCommands", "Enable / Disable 'Universal Passenger' development commands. ", "consoleCommandEnablePassengerCommands", self)

    self.raycastNodeErrors = 0

    self.updateMode = 1
    self.showRaycastNodesMode = 1

    self.rotationActive = false
    self.rotationFactor = 0.5
    self.translationFactor = 0.005

    self.transPassengerMode = true
    self.transCameraMode = true
    self.transPassengerPartsMode = true
    self.passengerMovmentActive = true
    self.bodyPart = 1

    self.bodyPartName = {"rightFoot", "leftFoot", "rightArm", "leftArm"}
    self.oppositePartName = {["rightFoot"] = "leftFoot", ["leftFoot"] = "rightFoot", ["rightArm"] = "leftArm", ["leftArm"] = "rightArm"}

    self.vehicles = {}

    return true
end

function UP_Creator:consoleCommandEnablePassengerCommands()
    if g_currentMission:getIsServer() and not g_currentMission.missionDynamicInfo.isMultiplayer then
        if self.active then
            self:removeConsoleCommands(false)
            self.vehicleList = nil

            local returnText = ""

            if self.charMovementActive then
                self.currentVehicle = nil
                self.currentSeatId = nil
                self.charMovementActive = false

                removeModEventListener(self)
                returnText = "CAUTION: Any movement to your passenger vehicles passenger indoor camera will affect your XML save if it is not already completed.\n"
            end

            self.active = false

            return returnText .. "'Universal Passenger' development commands disabled."
        else
            self.active = true

            if self.firstTimeRun then
                self.firstTimeRun = false
                Enterable.onLoad = Utils.prependedFunction(Enterable.onLoad, UP_Creator.collectXmlData)
            end

            addConsoleCommand("upExportI3dMappings", "Print or export the vehicle I3dMappings. [printToLog]", "consoleCommandExportI3dMappings", self)
            addConsoleCommand("upExportScenegraph", "Print or export the vehicle scenegraph. [printToLog] [graphviz]", "consoleCommandExportScenegraph", self)

            addConsoleCommand("upClearAllStoredSeats", "Clear all saved seat data.", "consoleCommandClearVehicleInfoTable", self)
            addConsoleCommand("upActivateSetupMovement", "Enable / Disable movement controls.", "consoleCommandActivateSetupMovement", self)

            addConsoleCommand("upReloadVehicleFiles", "Reload Base Vehicle XML file. [reloadAddonFiles]", "consoleCommandReloadGlobalVehicleFiles", self)

            addConsoleCommand("upStorePassengerSeats", "Store the passenger and camera position information for the current vehicle. [forceCreateXML] [cameraFromSeatPosition] [useSeatZ] [ignorePartsChangeMin]", "consoleCommandStorePassengerSeats", self)
            addConsoleCommand("upCreateXmlFromStoredPassengerSeats", "Create XML from saved seat data. Warning: Possible Heavy PC Load!", "consoleCommandCreatePassengerSeatsXML", self)

            addConsoleCommand("upCreateXmlFromList", "Create XML from list. [useSeatZ]", "consoleCommandCreatePassengerSeatsFromList", self)
            addConsoleCommand("upCreateListFromSpawnedVehicles", "Create new list from spawned steerable vehicles 'passenger will be in driver position'. [forceCreateXML] [useSeatZ]", "consoleCommandCreateListFromSpawnedVehicles", self)

            if UniversalPassenger.LOG_LEVEL[4] == true then
                self.isDev = true
                self.writeModInfo = true
                self:loadVehicleList()

                addConsoleCommand("upPrintSupportedModList", "(Dev Control) Print list of supported mods from addon file 'VehiclesOfModhub'.", "consoleCommandPrintSupportedModList", self)
                addConsoleCommand("upReloadVehicleList", "(Dev Control) Reload the standard vehicle list.", "consoleCommandReloadStandardVehicleList", self)
                addConsoleCommand("upCreateListFromVehicleCategory", "(Dev Control) Create new list from steerable vehicles in given category 'passenger will be in driver position'. [categoryName] [forceCreateXML] [useSeatZ]", "consoleCommandCreateListFromVehicleCategory", self)
                -- addConsoleCommand("upStoreAllSpawnedVehiclesPassengerSeats", "(Dev Control) Store the passenger and camera position information for all vehicles. [forceCreateXML] [cameraFromSeatPosition] [useSeatZ] [ignorePartsChangeMin]", "consoleCommandStoreAllVehiclesPassengerSeats", self)
            end

            return "'Universal Passenger' development commands enabled."
        end
    end

    return
end

function UP_Creator:registerActionEvents()
    local actionEventId

    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.TOGGLE_BEACON_LIGHTS, self, UP_Creator.actionEventPrintSeatData, false, true, false, true, nil)
    g_inputBinding:setActionEventText(actionEventId, "Print seat & camera2 XYZ data")
    g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    self.doPrintSeatData = actionEventId

    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.ATTACH, self, UP_Creator.actionEventUpdateMode, false, true, false, true, nil)
    g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    self.setUpdateMode = actionEventId

    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.TOGGLE_TURNLIGHT_RIGHT, self, UP_Creator.actionEventMovmentSpeed, false, true, false, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.TOGGLE_TURNLIGHT_LEFT, self, UP_Creator.actionEventMovmentSpeed, false, true, false, true, nil)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)


    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.IMPLEMENT_EXTRA4, self, UP_Creator.actionEventAdjustPassenger, false, true, false, true, nil)
    g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    self.adjustPassenger = actionEventId

    _, actionEventId = g_inputBinding:registerActionEvent(InputAction.IMPLEMENT_EXTRA3, self, UP_Creator.actionEventAdjustPassengerPart, false, true, false, true, nil)
    g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
    g_inputBinding:setActionEventTextVisibility(actionEventId, false)
    self.adjustPassengerPart = actionEventId

    self.actionEventsRegistered = true
end

function UP_Creator.actionEventPrintSeatData(self, actionName, inputValue, callbackState, isAnalog)
    if self.currentVehicle ~= nil and self.currentSeatId ~= nil then
        local spec = self.currentVehicle.spec_universalPassenger
        local seat = spec.passengerSeats[self.currentSeatId]

        local storeItem = g_storeManager:getItemByXMLFilename(self.currentVehicle.configFileName:lower())
        local printData = string.format("\n - Giants Editor Data  ( %s - %s ) -", g_brandManager:getBrandByIndex(storeItem.brandIndex).name, storeItem.name)
        local core = self:getTransRotXYZPrint(seat)

        printData = printData .. core

        local changesTable = self:getCharacterChanges(self.currentVehicle.configFileName, seat, self.currentSeatId, true)

        if changesTable ~= nil then
            printData = printData .. "\n - Passenger Body Parts - \n"

            for name, change in pairs (changesTable) do
                if (change.poseId == nil) or (change.poseId == "") then
                    printData = printData .. string.format("Passenger %s ( %s ) Position = %s  |  Rotation = %s \n", seat.id, name, change.position, change.rotation)
                else
                    printData = printData .. string.format("Passenger %s ( %s ) Position = %s  |  Rotation = %s  |  Finger Pose Id = %s\n", seat.id, name, change.position, change.rotation, change.poseId)
                end
            end
        end

        setFileLogPrefixTimestamp(false)
        print(printData .. "\n - Giants Editor Data  ( END ) - \n")
        setFileLogPrefixTimestamp(true)
    end
end

function UP_Creator.actionEventUpdateMode(self, actionName, inputValue, callbackState, isAnalog)
    if self.currentVehicle ~= nil and self.currentSeatId ~= nil then
        self.updateMode = self.updateMode + 1

        if self.updateMode > 3 then
            self.updateMode = 1
        end
    end
end

function UP_Creator.actionEventMovmentSpeed(self, actionName, inputValue, callbackState, isAnalog)
    if self.currentVehicle ~= nil and self.currentSeatId ~= nil then
        if actionName == "TOGGLE_TURNLIGHT_RIGHT" then
            if self.rotationActive then
                self.rotationFactor = math.min(self.rotationFactor + 0.1, 5)
            else
                if self.translationFactor == 0.001 then
                    self.translationFactor = 0
                end

                self.translationFactor = math.min(self.translationFactor + 0.005, 0.1)
            end
        elseif actionName == "TOGGLE_TURNLIGHT_LEFT" then
            if self.rotationActive then
                self.rotationFactor = math.max(self.rotationFactor - 0.1, 0.1)
            else
                self.translationFactor = math.max(self.translationFactor - 0.005, 0.001)
            end
        end
    end
end

function UP_Creator.actionEventAdjustPassenger(self, actionName, inputValue, callbackState, isAnalog)
    if self.currentVehicle ~= nil and self.currentSeatId ~= nil then
        if self.updateMode == 1 then
            self.transPassengerMode = not self.transPassengerMode
        elseif self.updateMode == 2 then
            self.transPassengerPartsMode = not self.transPassengerPartsMode
        elseif self.updateMode == 3 then
            self.transCameraMode = not self.transCameraMode
        end
    end
end

function UP_Creator.actionEventAdjustPassengerPart(self, actionName, inputValue, callbackState, isAnalog)
    if self.currentVehicle ~= nil and self.currentSeatId ~= nil then
        self.bodyPart = self.bodyPart + 1

        if self.bodyPart > 4 then
            self.bodyPart = 1
        end
    end
end

function UP_Creator.inputHasEvent(eventName, ignorePress)
    if UP_Creator.activeInputKeys[eventName] == true then
        UP_Creator.activeInputKeysCounter[eventName] = UP_Creator.activeInputKeysCounter[eventName] + 1

        if UP_Creator.activeInputKeysCounter[eventName] == 1 or UP_Creator.activeInputKeysCounter[eventName] > 40 then
            if ignorePress then
                UP_Creator.activeInputKeys[eventName] = false
            end

            return true
        end
    end

    return false
end

function UP_Creator:keyEvent(unicode, sym, modifier, isDown)
    if self.charMovementActive and self.currentVehicle ~= nil and self.currentSeatId ~= nil then
        local eventName = UP_Creator.inputKeys[sym]

        if eventName ~= nil then
            if isDown then
                UP_Creator.activeInputKeys[eventName] = true
                UP_Creator.activeInputKeysCounter[eventName] = 0
            else
                UP_Creator.activeInputKeys[eventName] = false
            end
        end
    end
end

function UP_Creator:update(dt)
    g_currentMission:addExtraPrintText("ACTIVE")

    if self.charMovementActive then
        self.currentVehicle = g_universalPassenger.currentPassengerVehicle
        self.currentSeatId = g_universalPassenger.currentPassengerSeatId

        if self.currentVehicle ~= nil and self.currentSeatId ~= nil then
            local spec = self.currentVehicle.spec_universalPassenger
            local seat = spec.passengerSeats[self.currentSeatId]
            local i3dCharacterNode = seat.creatorInfo ~= nil and seat.creatorInfo.i3dCharacterNode or nil

            if i3dCharacterNode == nil then
                return
            end

            if not self.actionEventsRegistered then
                self:registerActionEvents()
            end

            if self.updateMode == 1 or self.updateMode == 2 then
                -- Allow zoom to go in further so you can move player easy.
                if seat.cameras[1].oldTransMin == nil then
                    seat.cameras[1].oldTransMin = seat.cameras[1].transMin
                    seat.cameras[1].transMin = 0
                end

                if seat.passengerCharacter.oldCharacterCameraMinDistance == nil then
                    seat.passengerCharacter.oldCharacterCameraMinDistance = seat.passengerCharacter.characterCameraMinDistance
                    seat.passengerCharacter.characterCameraMinDistance = 0
                end

                if seat.cameraIndex ~= 1 then
                    self.currentVehicle:setPassengerCameraIndex(seat, 1)
                end

                spec.normalCamMode = true

                local camSet = false

                if seat.oldCameraData == nil then
                    local trans = {getTranslation(seat.cameras[1].rotateNode)}
                    local rot = {getRotation(seat.cameras[1].rotateNode)}

                    seat.oldCameraData = {trans = trans, rot = rot}
                    camSet = true
                end

                g_currentMission:addExtraPrintText("Use [ NumPad / ] to target 'Character Node'")

                if UP_Creator.inputHasEvent("NUMPAD_DIVIDE", false) then
                    local lx, ly, lz = localToLocal(i3dCharacterNode, self.currentVehicle.components[1].node, 0, 0, 0)
                    setTranslation(seat.cameras[1].rotateNode, lx, ly, lz)
                    setRotation(seat.cameras[1].rotateNode, lx, ly, lz)
                end
            else
                if seat.passengerCharacter.oldCharacterCameraMinDistance ~= nil then
                    seat.passengerCharacter.characterCameraMinDistance = seat.passengerCharacter.oldCharacterCameraMinDistance
                    seat.passengerCharacter.oldCharacterCameraMinDistance = nil
                end
            end

            if self.updateMode == 1 then -- Passenger Adjustment
                g_inputBinding:setActionEventText(self.setUpdateMode, "Mode: Passenger Adjustment")

                if self.transPassengerMode then
                    self.rotationActive = false
                    self.PassengerPartsMovmentActive = true

                    if self.passengerMovmentActive then
                        g_inputBinding:setActionEventText(self.adjustPassenger, "Type: Passenger Translation")
                        g_currentMission:addExtraPrintText("Use [ NumPad Arrows and + - ] to move.")

                        local x, y, z = getTranslation(i3dCharacterNode)

                        if UP_Creator.inputHasEvent("NUM+") then
                            setTranslation(i3dCharacterNode, x, y + self.translationFactor, z)
                        end

                        if UP_Creator.inputHasEvent("NUM-") then
                            setTranslation(i3dCharacterNode, x, y - self.translationFactor, z)
                        end

                        if UP_Creator.inputHasEvent("NUM_UP") then
                            setTranslation(i3dCharacterNode, x, y, z + self.translationFactor)
                        end

                        if UP_Creator.inputHasEvent("NUM_DOWN") then
                            setTranslation(i3dCharacterNode, x, y, z - self.translationFactor)
                        end

                        if UP_Creator.inputHasEvent("NUM_LEFT") then
                            setTranslation(i3dCharacterNode, x + self.translationFactor, y, z)
                        end

                        if UP_Creator.inputHasEvent("NUM_RIGHT") then
                            setTranslation(i3dCharacterNode, x - self.translationFactor, y, z)
                        end

                        x, y, z = UP_Creator.getRoundedTrans(i3dCharacterNode, 3, false)
                        g_currentMission:addExtraPrintText(string.format("X Y Z = %s | %s | %s", x, y, z))
                    elseif self.enableExitPointControls then
                        g_inputBinding:setActionEventText(self.adjustPassenger, "Type: Exit Point Translation")
                        g_currentMission:addExtraPrintText("Use [ NumPad Arrows and + - ] to move.")
                        g_currentMission:addExtraPrintText("Use [ NumPad * ] to clone standard exit location.")
                        g_currentMission:addExtraPrintText("Use [ NumPad . ] to set opposite standard exit location.")

                        if seat.tempPassengerExitNode == nil then
                            seat.tempPassengerExitNode = createTransformGroup("tempPassengerExitNode")
                            link(self.currentVehicle.components[1].node, seat.tempPassengerExitNode)

                            if seat.passengerExitNode ~= nil then
                                local x, y, z = getTranslation(seat.passengerExitNode)
                                setTranslation(seat.tempPassengerExitNode, x, y, z)
                            else
                                local exitNode = self.currentVehicle:getExitNode()

                                if exitNode ~= nil then
                                    local x, y, z = localToLocal(exitNode, self.currentVehicle.components[1].node, 0, 0, 0)
                                    setTranslation(seat.tempPassengerExitNode, x, y, z)
                                end
                            end
                        end

                        local wx, wy, wz = getWorldTranslation(seat.tempPassengerExitNode)
                        local rx, ry, rz = getWorldRotation(seat.cameras[1].cameraNode)

                        wy = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, wx, 0, wz) + 0.1

                        UP_Creator.render3DCircle(wx, wy, wz, rx, ry, rz, 0.5, 12, false, UP_Creator.debugColourPink)
                        UP_Creator.render3DTextAtWorldPosition(wx, wy, wz, rx, ry, rz, 0.12, string.format("Exit Point %d", self.currentSeatId), UP_Creator.debugColourBlue)

                        local x, y, z = getTranslation(seat.tempPassengerExitNode)

                        if UP_Creator.inputHasEvent("NUM_UP") then
                            setTranslation(seat.tempPassengerExitNode, x, y, z + self.translationFactor)
                        end

                        if UP_Creator.inputHasEvent("NUM_DOWN") then
                            setTranslation(seat.tempPassengerExitNode, x, y, z - self.translationFactor)
                        end

                        if UP_Creator.inputHasEvent("NUM_LEFT") then
                            setTranslation(seat.tempPassengerExitNode, x + self.translationFactor, y, z)
                        end

                        if UP_Creator.inputHasEvent("NUM_RIGHT") then
                            setTranslation(seat.tempPassengerExitNode, x - self.translationFactor, y, z)
                        end

                        if UP_Creator.inputHasEvent("NUMPAD_MULTIPLY", false) then
                            local exitNode = self.currentVehicle:getExitNode()

                            if exitNode ~= nil then
                                local lx, ly, lz = localToLocal(exitNode, self.currentVehicle.components[1].node, 0, 0, 0)
                                setTranslation(seat.tempPassengerExitNode, lx, ly, lz)
                            else
                                g_currentMission:showBlinkingWarning("Failed to clone standard exit location!")
                            end
                        end

                        if UP_Creator.inputHasEvent("NUMPAD_PERIOD", false) then
                            local exitNode = self.currentVehicle:getExitNode()

                            if exitNode ~= nil then
                                local lx, ly, lz = localToLocal(exitNode, self.currentVehicle.components[1].node, 0, 0, 0)
                                setTranslation(seat.tempPassengerExitNode, lx * -1, ly, lz)
                            else
                                g_currentMission:showBlinkingWarning("Failed to find standard exit location!")
                            end
                        end

                        x, y, z = UP_Creator.getRoundedTrans(seat.tempPassengerExitNode, 3, false)
                        g_currentMission:addExtraPrintText(string.format("X Y Z = %s | %s | %s", x, y, z))

                        -- Dev Check Only
                        if self.isDev and self.showRaycastNodesMode ~= nil then
                            if UP_Creator.inputHasEvent("NUMPAD_5", false) then
                                self.showRaycastNodesMode = self.showRaycastNodesMode + 1

                                if self.showRaycastNodesMode > 3 then
                                    self.showRaycastNodesMode = 1
                                end
                            end

                            if self.showRaycastNodesMode > 1 and seat.cameras[1].raycastNodes ~= nil then
                                for i, raycastNode in ipairs (seat.cameras[1].raycastNodes) do
                                    if i == 1 then
                                        DebugUtil.drawDebugNode(raycastNode, "Rotate Node", false)
                                    else
                                        DebugUtil.drawDebugNode(raycastNode, string.format("Raycast Node %d", i - 1), false)
                                    end
                                end

                                if self.showRaycastNodesMode > 2 then
                                    for i, raycastNode in ipairs (self.currentVehicle.spec_enterable.cameras[1].raycastNodes) do
                                        if i == 1 then
                                            DebugUtil.drawDebugNode(raycastNode, string.format("\nDriver Rotate Node"), false)
                                        else
                                            DebugUtil.drawDebugNode(raycastNode, string.format("\nDriver Raycast Node %d", i - 1), false)
                                        end
                                    end
                                end
                            end
                        end
                    else
                        self.passengerMovmentActive = true
                    end

                    if self.enableExitPointControls then
                        if UP_Creator.inputHasEvent("NUMPAD_0", false) then
                            self.passengerMovmentActive = not self.passengerMovmentActive
                        end

                        g_currentMission:addExtraPrintText("Use [ NumPad 0 ] - ( Passenger / Exit Point )")
                    end
                else
                    self.rotationActive = true
                    self.passengerMovmentActive = true
                    self.PassengerPartsMovmentActive = true

                    g_inputBinding:setActionEventText(self.adjustPassenger, "Type: Passenger Rotation")
                    g_currentMission:addExtraPrintText("Use [ NumPad Arrows ] to rotate.")
                    g_currentMission:addExtraPrintText("Use [ NumPad * ] to set and step (y) in 90° increments.")

                    local rx, ry, rz = getRotation(i3dCharacterNode)

                    if UP_Creator.inputHasEvent("NUM_UP") then
                        rx = UP_Creator.getCorrectedRotation(rx, math.rad(self.rotationFactor))
                        setRotation(i3dCharacterNode, rx, ry, rz)
                    end

                    if UP_Creator.inputHasEvent("NUM_DOWN") then
                        rx = UP_Creator.getCorrectedRotation(rx, math.rad(-self.rotationFactor))
                        setRotation(i3dCharacterNode, rx, ry, rz)
                    end

                    if UP_Creator.inputHasEvent("NUM_LEFT") then
                        ry = UP_Creator.getCorrectedRotation(ry, math.rad(self.rotationFactor))
                        setRotation(i3dCharacterNode, rx, ry, rz)
                    end

                    if UP_Creator.inputHasEvent("NUM_RIGHT") then
                        ry = UP_Creator.getCorrectedRotation(ry, math.rad(-self.rotationFactor))
                        setRotation(i3dCharacterNode, rx, ry, rz)
                    end

                    if UP_Creator.inputHasEvent("NUMPAD_MULTIPLY", false) then
                        local piHalf = math.pi * 0.5
                        local dif = piHalf - (math.abs(ry) % piHalf)

                        if ry < 0 then
                            if MathUtil.round(ry, 2) == -1.57 then
                                ry = 0
                                dif = 0
                            else
                                dif = piHalf - dif
                            end
                        end

                        setRotation(i3dCharacterNode, rx, UP_Creator.getCorrectedRotation(ry, dif), rz)
                    end

                    rx, ry, rz = UP_Creator.getRoundedRot(i3dCharacterNode, 3, false)
                    g_currentMission:addExtraPrintText(string.format("RX RY RZ = %.1f | %.1f | %.1f", rx, ry, rz))
                end
            elseif self.updateMode == 2 then -- Passenger Part Adjustment
                g_inputBinding:setActionEventText(self.setUpdateMode, "Mode: Passenger Body Part Adjustment")

                self:storeCharacterTargetNodes(self.currentVehicle.configFileName, seat, self.currentSeatId)
                self.passengerMovmentActive = true

                local pushChanges = false
                local part = self.bodyPartName[self.bodyPart]

                if self.transPassengerPartsMode then
                    self.rotationActive = false

                    g_currentMission:addExtraPrintText("Use [ NumPad Arrows and + - ] to move.")

                    if self.PassengerPartsMovmentActive then
                        g_inputBinding:setActionEventText(self.adjustPassenger, "Type: Body Part Translation")
                        g_currentMission:addExtraPrintText(string.format("Use [ NumPad * ] to copy '%s' translation.", self.oppositePartName[part]))

                        if UP_Creator.inputHasEvent("NUMPAD_MULTIPLY", false) then
                            local cx, cy, cz = getTranslation(seat.passengerCharacter.ikChainTargets[self.oppositePartName[part]].targetNode)
                            setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, -cx, cy, cz)
                            pushChanges = true
                        end

                        local x, y, z = getTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode)

                        if UP_Creator.inputHasEvent("NUM+") then
                            setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, x, y + self.translationFactor, z)
                            pushChanges = true
                        end

                        if UP_Creator.inputHasEvent("NUM-") then
                            setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, x, y - self.translationFactor, z)
                            pushChanges = true
                        end

                        if UP_Creator.inputHasEvent("NUM_UP") then
                            setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, x, y, z + self.translationFactor)
                            pushChanges = true
                        end

                        if UP_Creator.inputHasEvent("NUM_DOWN") then
                            setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, x, y, z - self.translationFactor)
                            pushChanges = true
                        end

                        if UP_Creator.inputHasEvent("NUM_LEFT") then
                            setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, x + self.translationFactor, y, z)
                            pushChanges = true
                        end

                        if UP_Creator.inputHasEvent("NUM_RIGHT") then
                            setTranslation(seat.passengerCharacter.ikChainTargets[part].targetNode, x - self.translationFactor, y, z)
                            pushChanges = true
                        end

                        x, y, z = UP_Creator.getRoundedTrans(seat.passengerCharacter.ikChainTargets[part].targetNode, 3, false)
                        g_currentMission:addExtraPrintText(string.format("X Y Z = %s | %s | %s", x, y, z))
                    else
                        if seat.partChange ~= nil then
                            g_inputBinding:setActionEventText(self.adjustPassenger, string.format("Type: Part Change Translation ( %s )", tostring(seat.partChange.indexString)))

                            local x, y, z = getTranslation(seat.partChange.index)

                            if UP_Creator.inputHasEvent("NUM+") then
                                setTranslation(seat.partChange.index, x, y + self.translationFactor, z)
                                seat.partChange.transMax[2] = y
                            end

                            if UP_Creator.inputHasEvent("NUM-") then
                                setTranslation(seat.partChange.index, x, y - self.translationFactor, z)
                                seat.partChange.transMax[2] = y
                            end

                            if UP_Creator.inputHasEvent("NUM_UP") then
                                setTranslation(seat.partChange.index, x, y, z + self.translationFactor)
                                seat.partChange.transMax[3] = z
                            end

                            if UP_Creator.inputHasEvent("NUM_DOWN") then
                                setTranslation(seat.partChange.index, x, y, z - self.translationFactor)
                                seat.partChange.transMax[3] = z
                            end

                            if UP_Creator.inputHasEvent("NUM_LEFT") then
                                setTranslation(seat.partChange.index, x + self.translationFactor, y, z)
                                seat.partChange.transMax[1] = x
                            end

                            if UP_Creator.inputHasEvent("NUM_RIGHT") then
                                setTranslation(seat.partChange.index, x - self.translationFactor, y, z)
                                seat.partChange.transMax[1] = x
                            end

                            x, y, z = UP_Creator.getRoundedTrans(seat.partChange.index, 3, false)
                            g_currentMission:addExtraPrintText(string.format("X Y Z = %s | %s | %s", x, y, z))
                        else
                            self.PassengerPartsMovmentActive = true
                        end
                    end
                else
                    self.rotationActive = true

                    g_currentMission:addExtraPrintText("Use [ NumPad Arrows and + - ] to rotate.")

                    if self.PassengerPartsMovmentActive then
                        g_inputBinding:setActionEventText(self.adjustPassenger, "Type: Body Part Rotation")
                        -- g_currentMission:addExtraPrintText("Use NumPad * to copy " .. self.oppositePartName[part] .. " rotation.")
                        g_currentMission:addExtraPrintText("Use [ NumPad 7 & 9 ] for Z Spine Rotation")

                        if UP_Creator.inputHasEvent("NUMPAD_9") then
                            seat.passengerCharacter.characterSpineRotation[3] = seat.passengerCharacter.characterSpineRotation[3] + math.rad(1)
                            pushChanges = true
                        elseif UP_Creator.inputHasEvent("NUMPAD_7") then
                            seat.passengerCharacter.characterSpineRotation[3] = seat.passengerCharacter.characterSpineRotation[3] - math.rad(1)
                            pushChanges = true
                        end

                        -- if UP_Creator.inputHasEvent("NUMPAD_MULTIPLY", false) then
                            -- local crx, cry, crz = getRotation(seat.passengerCharacter.ikChainTargets[self.oppositePartName[part]].targetNode)
                            -- setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, crx, cry, crz)
                            -- pushChanges = true
                        -- end

                        local rx, ry, rz = getRotation(seat.passengerCharacter.ikChainTargets[part].targetNode)
                        if UP_Creator.inputHasEvent("NUM+") then
                            rz = UP_Creator.getCorrectedRotation(rz, math.rad(self.rotationFactor))
                            setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, rx, ry, rz)
                            pushChanges = true
                        end

                        if UP_Creator.inputHasEvent("NUM-") then
                            rz = UP_Creator.getCorrectedRotation(rz, math.rad(-self.rotationFactor))
                            setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, rx, ry, rz)
                            pushChanges = true
                        end

                        if UP_Creator.inputHasEvent("NUM_UP") then
                            rx = UP_Creator.getCorrectedRotation(rx, math.rad(self.rotationFactor))
                            setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, rx, ry, rz)
                            pushChanges = true
                        end

                        if UP_Creator.inputHasEvent("NUM_DOWN") then
                            rx = UP_Creator.getCorrectedRotation(rx, math.rad(-self.rotationFactor))
                            setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, rx, ry, rz)
                            pushChanges = true
                        end

                        if UP_Creator.inputHasEvent("NUM_LEFT") then
                            ry = UP_Creator.getCorrectedRotation(ry, math.rad(self.rotationFactor))
                            setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, rx, ry, rz)
                            pushChanges = true
                        end

                        if UP_Creator.inputHasEvent("NUM_RIGHT") then
                            ry = UP_Creator.getCorrectedRotation(ry, math.rad(-self.rotationFactor))
                            setRotation(seat.passengerCharacter.ikChainTargets[part].targetNode, rx, ry, rz)
                            pushChanges = true
                        end

                        rx, ry, rz = UP_Creator.getRoundedRot(seat.passengerCharacter.ikChainTargets[part].targetNode, 3, false)
                        g_currentMission:addExtraPrintText(string.format("RX RY RZ = %.1f | %.1f | %.1f", rx, ry, rz))

                        local spineZ = UP_Creator.getValidValue(MathUtil.round(math.deg(seat.passengerCharacter.characterSpineRotation[3], 0)))
                        g_currentMission:addExtraPrintText(string.format("Spine - RX RY RZ = -90 | 0 | %.1f", spineZ))
                    else
                        if seat.partChange ~= nil then
                            g_inputBinding:setActionEventText(self.adjustPassenger, string.format("Type: Part Change Rotation ( %s )", tostring(seat.partChange.indexString)))

                            local rx, ry, rz = getRotation(seat.partChange.index)

                            if UP_Creator.inputHasEvent("NUM+") then
                                rz = UP_Creator.getCorrectedRotation(rz, math.rad(self.rotationFactor))
                                setRotation(seat.partChange.index, rx, ry, rz)
                                seat.partChange.rotMax[3] = rz
                            end

                            if UP_Creator.inputHasEvent("NUM-") then
                                rz = UP_Creator.getCorrectedRotation(rz, math.rad(-self.rotationFactor))
                                setRotation(seat.partChange.index, rx, ry, rz)
                                seat.partChange.rotMax[3] = rz
                            end

                            if UP_Creator.inputHasEvent("NUM_UP") then
                                rx = UP_Creator.getCorrectedRotation(rx, math.rad(self.rotationFactor))
                                setRotation(seat.partChange.index, rx, ry, rz)
                                seat.partChange.rotMax[1] = rx
                            end

                            if UP_Creator.inputHasEvent("NUM_DOWN") then
                                rx = UP_Creator.getCorrectedRotation(rx, math.rad(-self.rotationFactor))
                                setRotation(seat.partChange.index, rx, ry, rz)
                                seat.partChange.rotMax[1] = rx
                            end

                            if UP_Creator.inputHasEvent("NUM_LEFT") then
                                ry = UP_Creator.getCorrectedRotation(ry, math.rad(self.rotationFactor))
                                setRotation(seat.partChange.index, rx, ry, rz)
                                seat.partChange.rotMax[2] = ry
                            end

                            if UP_Creator.inputHasEvent("NUM_RIGHT") then
                                ry = UP_Creator.getCorrectedRotation(ry, math.rad(-self.rotationFactor))
                                setRotation(seat.partChange.index, rx, ry, rz)
                                seat.partChange.rotMax[2] = ry
                            end

                            rx, ry, rz = UP_Creator.getRoundedRot(seat.partChange.index, 3, false)
                            g_currentMission:addExtraPrintText(string.format("RX RY RZ = %.1f | %.1f | %.1f", rx, ry, rz))
                        else
                            self.PassengerPartsMovmentActive = true
                        end
                    end
                end

                if self.isDev and seat.partChange ~= nil then
                    if UP_Creator.inputHasEvent("NUMPAD_PERIOD", false) then
                        self.PassengerPartsMovmentActive = not self.PassengerPartsMovmentActive
                    end

                    if not self.PassengerPartsMovmentActive then
                        if UP_Creator.inputHasEvent("NUMPAD_MULTIPLY", false) then
                            if self.rotationActive then
                                setRotation(seat.partChange.index, seat.partChange.rotMin[1], seat.partChange.rotMin[2], seat.partChange.rotMin[3])
                            else
                                setTranslation(seat.partChange.index, seat.partChange.transMin[1], seat.partChange.transMin[2], seat.partChange.transMin[3])
                            end
                        end

                        if self.rotationActive then
                            g_currentMission:addExtraPrintText("Use NumPad * to reset rotation.")
                        else
                            g_currentMission:addExtraPrintText("Use NumPad * to reset translation.")
                        end
                    end

                    g_currentMission:addExtraPrintText("Use [ NumPad . ] - ( Passenger Parts / Part Change )")
                end

                if (part == "rightArm") or (part == "leftArm") then
                    local poseId = seat.passengerCharacter.poseIds[part]
                    if poseId == "" then
                        poseId = "narrowFingers"
                    end

                    g_currentMission:addExtraPrintText(string.format("Use [ NumPad 0 ] - ( Finger position: %s )", tostring(poseId)))

                    if UP_Creator.inputHasEvent("NUMPAD_0", false) then
                        local currentIndex = UP_Creator.poseIdToIndex[poseId] or 1

                        currentIndex = currentIndex + 1

                        if currentIndex > 3 then
                            currentIndex = 1
                        end

                        local newPoseId = UP_Creator.poseIndexToId[currentIndex]
                        local chain = IKUtil.getIKChainByTarget(seat.passengerCharacter.ikChains, seat.passengerCharacter.ikChainTargets[part].targetNode)
                        if chain ~= nil then
                            IKUtil.setIKChainPose(seat.passengerCharacter.ikChains, chain.id, newPoseId)
                        end

                        seat.passengerCharacter.poseIds[part] = newPoseId
                        seat.passengerCharacter.ikChainTargets[part].poseId = newPoseId -- Change so setting is kept if 'pushChanges' is true.
                    end
                end

                if pushChanges then
                    local playerStyle = g_currentMission.player.visualInformation
                    local playerModel = g_playerModelManager:getPlayerModelByIndex(playerStyle.selectedModelIndex)

                    seat.passengerCharacter:delete()
                    seat.passengerCharacter:loadCharacter(playerModel.xmlFilename, playerStyle)
                    seat.passengerCharacter:updateIKChains()
                end

                g_inputBinding:setActionEventText(self.adjustPassengerPart, string.format("Selected Body Part ( %s )", self.bodyPartName[self.bodyPart] or "N/A"))
            elseif self.updateMode == 3 then -- Indoor Camera Adjustment
                g_inputBinding:setActionEventText(self.setUpdateMode, "Mode: Inside Camera Adjustment")

                if seat.cameraIndex ~= 2 then
                    self.currentVehicle:setPassengerCameraIndex(seat, 2)
                end

                spec.normalCamMode = false
                self.passengerMovmentActive = true
                self.PassengerPartsMovmentActive = true

                if self.transCameraMode then
                    self.rotationActive = false

                    g_inputBinding:setActionEventText(self.adjustPassenger, "Type: Camera Translation")
                    g_currentMission:addExtraPrintText("Use [ NumPad Arrows and + - ] to move.")
                    g_currentMission:addExtraPrintText("Use [ NumPad * ] to reset camera translation.")

                    if UP_Creator.inputHasEvent("NUMPAD_MULTIPLY", false) then
                        -- local x, y, z = getTranslation(i3dCharacterNode)
                        local lx, ly, lz = localToLocal(i3dCharacterNode, self.currentVehicle.components[1].node, 0, 0, 0)
                        setTranslation(seat.cameras[2].rotateNode, lx, ly + 0.7, lz)
                        seat.cameras[2]:onActivate()
                    end

                    local x, y, z = getTranslation(seat.cameras[2].rotateNode)
                    if UP_Creator.inputHasEvent("NUM+") then
                        setTranslation(seat.cameras[2].rotateNode, x, y + self.translationFactor, z)
                        seat.cameras[2]:onActivate()
                    end

                    if UP_Creator.inputHasEvent("NUM-") then
                        setTranslation(seat.cameras[2].rotateNode, x, y - self.translationFactor, z)
                        seat.cameras[2]:onActivate()
                    end

                    if UP_Creator.inputHasEvent("NUM_UP") then
                        setTranslation(seat.cameras[2].rotateNode, x, y, z + self.translationFactor)
                        seat.cameras[2]:onActivate()
                    end

                    if UP_Creator.inputHasEvent("NUM_DOWN") then
                        setTranslation(seat.cameras[2].rotateNode, x, y, z - self.translationFactor)
                        seat.cameras[2]:onActivate()
                    end

                    if UP_Creator.inputHasEvent("NUM_LEFT") then
                        setTranslation(seat.cameras[2].rotateNode, x + self.translationFactor, y, z)
                        seat.cameras[2]:onActivate()
                    end

                    if UP_Creator.inputHasEvent("NUM_RIGHT") then
                        setTranslation(seat.cameras[2].rotateNode, x - self.translationFactor, y, z)
                        seat.cameras[2]:onActivate()
                    end

                    x, y, z = UP_Creator.getRoundedTrans(seat.cameras[2].rotateNode, 3, false)
                    g_currentMission:addExtraPrintText(string.format("X Y Z = %s | %s | %s", x, y, z))
                else
                    self.rotationActive = true

                    g_inputBinding:setActionEventText(self.adjustPassenger, "Type: Camera Rotation")
                    g_currentMission:addExtraPrintText("Use [ NumPad Arrows ] to rotate.")
                    g_currentMission:addExtraPrintText("Use [ NumPad * ] to reset inside camera rotation.")

                    if UP_Creator.inputHasEvent("NUMPAD_MULTIPLY", false) then
                        local _, y, _ = getRotation(i3dCharacterNode)
                        local degY = MathUtil.round(math.deg(y), 0)

                        if degY > 0 then
                            degY = UP_Creator.getValidValue(MathUtil.round(degY - 180, 0))
                        elseif degY < 0 then
                            degY = UP_Creator.getValidValue(MathUtil.round(degY + 180, 0))
                        else
                            degY = 180
                        end

                        setRotation(seat.cameras[2].rotateNode, math.rad(-14), math.rad(degY), math.rad(0))
                        seat.cameras[2]:onActivate()
                    end

                    local rx, ry, rz = getRotation(seat.cameras[2].rotateNode)
                    if UP_Creator.inputHasEvent("NUM_UP") then
                        rx = UP_Creator.getCorrectedRotation(rx, math.rad(self.rotationFactor))
                        setRotation(seat.cameras[2].rotateNode, rx, ry, rz)
                        seat.cameras[2]:onActivate()
                    end

                    if UP_Creator.inputHasEvent("NUM_DOWN") then
                        rx = UP_Creator.getCorrectedRotation(rx, math.rad(-self.rotationFactor))
                        setRotation(seat.cameras[2].rotateNode, rx, ry, rz)
                        seat.cameras[2]:onActivate()
                    end

                    if UP_Creator.inputHasEvent("NUM_LEFT") then
                        ry = UP_Creator.getCorrectedRotation(ry, math.rad(self.rotationFactor))
                        setRotation(seat.cameras[2].rotateNode, rx, ry, rz)
                        seat.cameras[2]:onActivate()
                    end

                    if UP_Creator.inputHasEvent("NUM_RIGHT") then
                        ry = UP_Creator.getCorrectedRotation(ry, math.rad(-self.rotationFactor))
                        setRotation(seat.cameras[2].rotateNode, rx, ry, rz)
                        seat.cameras[2]:onActivate()
                    end

                    rx, ry, rz = UP_Creator.getRoundedRot(seat.cameras[2].rotateNode, 3, false)
                    g_currentMission:addExtraPrintText(string.format("RX RY RZ = %.1f | %.1f | %.1f", rx, ry, rz))
                end

                if seat.cameras[2].useMirror == nil then
                    seat.cameras[2].useMirror = false
                end

                g_currentMission:addExtraPrintText(string.format("Use [ NumPad 0 ] - ( Use Mirrors: %s )", tostring(seat.cameras[2].useMirror)))

                if UP_Creator.inputHasEvent("NUMPAD_0", false) then
                    seat.cameras[2].useMirror = not seat.cameras[2].useMirror
                    self.currentVehicle:setPassengerMirrorVisible(seat.cameras[2].useMirror)
                end

                if seat.cameras[2].isInside == nil then
                    seat.cameras[2].isInside = true
                end

                g_currentMission:addExtraPrintText(string.format("Use [ NumPad / ] - ( Inside Seat: %s )", tostring(seat.cameras[2].isInside)))

                if UP_Creator.inputHasEvent("NUMPAD_DIVIDE", false) then
                    seat.cameras[2].isInside = not seat.cameras[2].isInside
                end

                if self.enableOutdoorSoundControls then
                    if seat.cameras[2].useOutdoorSounds == nil then
                        seat.cameras[2].useOutdoorSounds = false
                    end

                    g_currentMission:addExtraPrintText(string.format("Use [ NumPad . ] - ( Outdoor Sounds: %s )", tostring(seat.cameras[2].useOutdoorSounds)))

                    if UP_Creator.inputHasEvent("NUMPAD_PERIOD", false) then
                        seat.cameras[2].useOutdoorSounds = not seat.cameras[2].useOutdoorSounds
                    end
                end
            end

            if self.rotationActive then
                g_currentMission:addExtraPrintText(string.format("Use [ NumPad 1 & 3 ] - ( Rotation Speed: %s )", tostring(self.rotationFactor)))
            else
                g_currentMission:addExtraPrintText(string.format("Use [ NumPad 1 & 3 ] - ( Translation Speed: %s )", tostring(self.translationFactor)))
            end

            if seat.passengerCharacter ~= nil and seat.passengerCharacter.ikChainTargets ~= nil then
                UP_Creator.debugRenderTargetNodes(seat.passengerCharacter.ikChainTargets, dt)
            end

            g_inputBinding:setActionEventTextVisibility(self.setUpdateMode, true)
            g_inputBinding:setActionEventTextVisibility(self.doPrintSeatData, true)
            g_inputBinding:setActionEventTextVisibility(self.adjustPassenger, true)

            local bindingActive = self.PassengerPartsMovmentActive and self.updateMode == 2
            g_inputBinding:setActionEventTextVisibility(self.adjustPassengerPart, bindingActive)
            g_inputBinding:setActionEventActive(self.adjustPassengerPart, bindingActive)
        else
            if self.actionEventsRegistered then
                g_inputBinding:setActionEventTextVisibility(self.setUpdateMode, false)
                g_inputBinding:setActionEventTextVisibility(self.doPrintSeatData, false)
                g_inputBinding:setActionEventTextVisibility(self.adjustPassenger, false)
                g_inputBinding:setActionEventTextVisibility(self.adjustPassengerPart, false)

                g_inputBinding:removeActionEventsByTarget(self)
                self.actionEventsRegistered = false
            end
        end
    end
end

function UP_Creator.debugRenderTargetNodes(ikChainTargets, dt)
    DebugUtil.drawDebugNode(ikChainTargets["rightFoot"].targetNode, nil, false)
    DebugUtil.drawDebugNode(ikChainTargets["leftFoot"].targetNode, nil, false)
    DebugUtil.drawDebugNode(ikChainTargets["rightArm"].targetNode, nil, false)
    DebugUtil.drawDebugNode(ikChainTargets["leftArm"].targetNode, nil, false)
end

function UP_Creator.render3DCircle(x, y, z, rx, ry, rz, radius, steps, drawCentre, r, g, b)
    rgb = rgb or UP_Creator.debugColourPink
    radius = radius or 0.5
    steps = steps or 12

    setTextBold(true)
    setTextColor(rgb[1], rgb[2], rgb[3], 1)
    setTextAlignment(RenderText.ALIGN_CENTER)

    for i = 1, steps do
        local a1 = (i - 1) / steps * 2 * math.pi
        local a2 = i / steps * 2 * math.pi

        local x1 = x + (math.cos(a1) * radius)
        local z1 = z + (math.sin(a1) * radius)

        local x2 = x + (math.cos(a2) * radius)
        local z2 = z + (math.sin(a2) * radius)

        renderText3D(x1, y, z1, rx, ry, rz, 0.5, ".", rgb)
        renderText3D(x2, y, z2, rx, ry, rz, 0.5, ".", rgb)
    end

    if drawCentre then
        renderText3D(x, y, z, rx, ry, rz, 0.5, ".", rgb)
    end

    setTextBold(false)
    setTextColor(1, 1, 1, 1)
    setTextAlignment(RenderText.ALIGN_LEFT)
end

function UP_Creator.render3DTextAtWorldPosition(x1, y1, z1, rx, ry, rz, textSize, text, rgb)
    rgb = rgb or UP_Creator.debugColourBlue
    setTextBold(true)
    setTextColor(rgb[1], rgb[2], rgb[3], 1)
    setTextAlignment(RenderText.ALIGN_CENTER)
    renderText3D(x1, y1, z1, rx, ry, rz, textSize, text)
    setTextBold(false)
    setTextColor(1, 1, 1, 1)
    setTextAlignment(RenderText.ALIGN_LEFT)
end

function UP_Creator:removeConsoleCommands(isDelete)
    if isDelete then
        removeConsoleCommand("upEnablePassengerCommands")
    end

    if self.active then
        removeConsoleCommand("upExportScenegraph")
        removeConsoleCommand("upExportI3dMappings")

        removeConsoleCommand("upReloadVehicleFiles")
        removeConsoleCommand("upClearAllStoredSeats")
        removeConsoleCommand("upStorePassengerSeats")
        removeConsoleCommand("upActivateSetupMovement")
        removeConsoleCommand("upCreateXmlFromStoredPassengerSeats")

        removeConsoleCommand("upCreateXmlFromList")
        removeConsoleCommand("upCreateListFromSpawnedVehicles")

        if self.isDev then
            removeConsoleCommand("upReloadVehicleList")
            removeConsoleCommand("upPrintSupportedModList")
            removeConsoleCommand("upCreateListFromVehicleCategory")
            -- removeConsoleCommand("upStoreAllSpawnedVehiclesPassengerSeats")
        end
    end

    if self.charMovementActive and self.actionEventsRegistered then
        g_inputBinding:removeActionEventsByTarget(self)
        self.actionEventsRegistered = false
    end
end

function UP_Creator:consoleCommandActivateSetupMovement()
    self.charMovementActive = not self.charMovementActive

    if self.charMovementActive then
        self.updateMode = 1
        self:registerActionEvents()

        self.currentVehicle = nil
        self.currentSeatId = nil

        addModEventListener(self)

        return "INFO: Setup movement is enabled."
    else
        self.updateMode = 1
        self.actionEventsRegistered = false
        g_inputBinding:removeActionEventsByTarget(self)

        self.currentVehicle = nil
        self.currentSeatId = nil

        removeModEventListener(self)

        for _, vehicle in pairs (g_universalPassenger.passengerVehicles) do
            vehicle.spec_universalPassenger.normalCamMode = true

            for _, seat in pairs (vehicle.spec_universalPassenger.passengerSeats) do
                if seat.passengerCharacter.oldCharacterCameraMinDistance ~= nil then
                    seat.passengerCharacter.characterCameraMinDistance = seat.passengerCharacter.oldCharacterCameraMinDistance
                    seat.passengerCharacter.oldCharacterCameraMinDistance = nil
                end

                if seat.cameras[1].oldTransMin ~= nil then
                    seat.cameras[1].transMin = seat.cameras[1].oldTransMin
                    seat.cameras[1].oldTransMin = nil
                end

                if seat.oldCameraData ~= nil then
                    if seat.oldCameraData.trans ~= nil then
                        local x, y, z = unpack(seat.oldCameraData.trans)
                        setTranslation(seat.cameras[1].rotateNode, x, y, z)
                    end

                    if seat.oldCameraData.rot ~= nil then
                        local rx, ry, rz = unpack(seat.oldCameraData.rot)
                        setRotation(seat.cameras[1].rotateNode, rx, ry, rz)
                    end
                end
            end
        end

        return "CAUTION: (Global XML Only) Any movement to your passenger vehicle indoor camera will affect your XML save data if XML is not already saved.\n Setup movement is disabled."
    end
end

function UP_Creator:consoleCommandStorePassengerSeats(forceCreateXML, cameraFromSeatPosition, useSeatZ, ignorePartsChangeMin)
    if g_currentMission:getIsServer() and not g_currentMission.missionDynamicInfo.isMultiplayer then
        if self.vehicleInfo == nil then
            self.vehicleInfo = {}
        end

        cameraFromSeatPosition = Utils.stringToBoolean(cameraFromSeatPosition)

        local vehicle = g_universalPassenger.currentPassengerVehicle

        if vehicle ~= nil and vehicle.spec_universalPassenger.passengerSeats ~= nil then
            local oldId

            for v = 1, #self.vehicleInfo do
                if self.vehicleInfo[v].xmlFilename == vehicle.configFileName then
                    oldId = v
                    table.remove(self.vehicleInfo, v) -- Create No duplicates. Clear old entries first if they exist.

                    break
                end
            end

            local spec = vehicle.spec_universalPassenger
            local vehicleInfo = {
                seats = {},
                xmlFilename = vehicle.configFileName,
                useSeatZ = Utils.stringToBoolean(useSeatZ)
            }

            for s = 1, #spec.passengerSeats do
                local seat = spec.passengerSeats[s]

                vehicleInfo.seats[s] = {}

                if seat.creatorInfo ~= nil then
                    vehicleInfo.seats[s].characterLinkNodeStr = seat.creatorInfo.characterLinkNodeStr
                    vehicleInfo.seats[s].outsideCameraLinkNodeStr = seat.creatorInfo.outsideCameraLinkNodeStr
                    vehicleInfo.seats[s].insideCameraLinkNodeStr = seat.creatorInfo.insideCameraLinkNodeStr

                    if seat.creatorInfo.i3dCharacterNode ~= nil then
                        if seat.characterLinkNode == nil then
                            vehicleInfo.seats[s].position = UP_Creator.getRoundedTrans(seat.creatorInfo.i3dCharacterNode, 3, true)
                        else
                            local position = {localToLocal(seat.creatorInfo.i3dCharacterNode, vehicle.components[1].node, 0, 0, 0)}

                            vehicleInfo.seats[s].characterLinkNodeOffset = true
                            vehicleInfo.seats[s].position = UP_Creator.getRoundedTable(position, 3, false, true)
                        end

                        local rx, ry, rz = UP_Creator.getRoundedRot(seat.creatorInfo.i3dCharacterNode, 3)

                        if rx ~= 0 or ry ~= 0 or rz ~= 0 then
                            vehicleInfo.seats[s].rotation = string.format("%s %s %s", rx, ry, rz)
                        end
                    end

                    vehicleInfo.seats[s].exitNodePositionStr = seat.creatorInfo.exitNodePositionStr
                end

                if seat.tempPassengerExitNode ~= nil then
                    local exitNode = seat.passengerExitNode or vehicle:getExitNode()

                    if exitNode ~= nil then
                        local tempX, _, tempZ = getWorldTranslation(seat.tempPassengerExitNode)
                        local exitNodeX, _, exitNodeZ = getWorldTranslation(exitNode)

                        if math.abs(exitNodeX - tempX) > 0.5 or math.abs(exitNodeZ - tempZ) > 0.5 then
                            vehicleInfo.seats[s].exitNodePositionStr = UP_Creator.getRoundedTrans(seat.tempPassengerExitNode, 3, true)
                        end
                    end
                end

                vehicleInfo.seats[s].isInside = Utils.getNoNil(seat.cameras[2].isInside, true)
                vehicleInfo.seats[s].useMirror = Utils.getNoNil(seat.cameras[2].useMirror, false)
                vehicleInfo.seats[s].useOutdoorSounds = Utils.getNoNil(seat.cameras[2].useOutdoorSounds, false)

                if not cameraFromSeatPosition and not seat.cameras[2].hasExtraRotationNode then
                    vehicleInfo.seats[s].insideCamera = {}

                    if seat.insideCameraLinkNode == nil then
                        vehicleInfo.seats[s].insideCamera.position = UP_Creator.getRoundedTrans(seat.cameras[2].rotateNode, 3, true)
                    else
                        local position = {localToLocal(seat.cameras[2].rotateNode, vehicle.components[1].node, 0, 0, 0)}

                        vehicleInfo.seats[s].insideCameraLinkNodeOffset = true
                        vehicleInfo.seats[s].insideCamera.position = UP_Creator.getRoundedTable(position, 3, false, true)
                    end

                    vehicleInfo.seats[s].insideCamera.rotation = UP_Creator.getRoundedRot(seat.cameras[2].rotateNode, nil, true)
                end

                local characterChanges = self:getCharacterChanges(vehicle.configFileName, seat, s, false)

                if characterChanges ~= nil then
                    vehicleInfo.seats[s].passengerCharacter = characterChanges
                end

                vehicleInfo.seats[s].zSpineRotation = MathUtil.round(math.deg(seat.passengerCharacter.characterSpineRotation[3]))

                if seat.partChange ~= nil then
                    ignorePartsChangeMin = ignorePartsChangeMin == nil or loadAddons:lower() == "true"
                    vehicleInfo.seats[s].partChange = self:collectPartsInfo(seat.partChange, ignorePartsChangeMin)
                end

                if seat.passengerEnterAnimation ~= nil then
                    vehicleInfo.seats[s].enterAnimation = seat.passengerEnterAnimation
                end
            end

            if oldId ~= nil then
                table.insert(self.vehicleInfo, oldId, vehicleInfo)
            else
                table.insert(self.vehicleInfo, vehicleInfo)
            end

            forceCreateXML = Utils.stringToBoolean(forceCreateXML)

            if forceCreateXML then
                local returnText = "INFO: Force creating XML now. Please wait."

                return self:consoleCommandCreatePassengerSeatsXML(returnText)
            else
                return "INFO: This vehicles passenger seat(s) data have been saved."
            end
        else
            return "INFO: You must first enter a vehicle as a passenger."
        end
    end
end

function UP_Creator:consoleCommandStoreAllVehiclesPassengerSeats(forceCreateXML, cameraFromSeatPosition, useSeatZ, ignorePartsChangeMin)
    if g_currentMission:getIsServer() and not g_currentMission.missionDynamicInfo.isMultiplayer then

        self.vehicleInfo = {}
        cameraFromSeatPosition = Utils.stringToBoolean(cameraFromSeatPosition)

        for _, vehicle in pairs (g_universalPassenger.passengerVehicles) do
            local spec = vehicle.spec_universalPassenger
            local vehicleInfo = {
                seats = {},
                xmlFilename = vehicle.configFileName,
                useSeatZ = Utils.stringToBoolean(useSeatZ)
            }

            for s = 1, #spec.passengerSeats do
                local seat = spec.passengerSeats[s]

                vehicleInfo.seats[s] = {}

                if seat.creatorInfo ~= nil then
                    vehicleInfo.seats[s].characterLinkNodeStr = seat.creatorInfo.characterLinkNodeStr
                    vehicleInfo.seats[s].outsideCameraLinkNodeStr = seat.creatorInfo.outsideCameraLinkNodeStr
                    vehicleInfo.seats[s].insideCameraLinkNodeStr = seat.creatorInfo.insideCameraLinkNodeStr

                    if seat.creatorInfo.i3dCharacterNode ~= nil then
                        if seat.characterLinkNode == nil then
                            vehicleInfo.seats[s].position = UP_Creator.getRoundedTrans(seat.creatorInfo.i3dCharacterNode, 3, true)
                        else
                            local position = {localToLocal(seat.creatorInfo.i3dCharacterNode, vehicle.components[1].node, 0, 0, 0)}

                            vehicleInfo.seats[s].characterLinkNodeOffset = true
                            vehicleInfo.seats[s].position = UP_Creator.getRoundedTable(position, 3, false, true)
                        end

                        local rx, ry, rz = UP_Creator.getRoundedRot(seat.creatorInfo.i3dCharacterNode, 3)

                        if rx ~= 0 or ry ~= 0 or rz ~= 0 then
                            vehicleInfo.seats[s].rotation = string.format("%s %s %s", rx, ry, rz)
                        end
                    end

                    vehicleInfo.seats[s].exitNodePositionStr = seat.creatorInfo.exitNodePositionStr
                end

                if seat.tempPassengerExitNode ~= nil then
                    local exitNode = seat.passengerExitNode or vehicle:getExitNode()

                    if exitNode ~= nil then
                        local tempX, _, tempZ = getWorldTranslation(seat.tempPassengerExitNode)
                        local exitNodeX, _, exitNodeZ = getWorldTranslation(exitNode)

                        if math.abs(exitNodeX - tempX) > 0.5 or math.abs(exitNodeZ - tempZ) > 0.5 then
                            vehicleInfo.seats[s].exitNodePositionStr = UP_Creator.getRoundedTrans(seat.tempPassengerExitNode, 3, true)
                        end
                    end
                end

                if not cameraFromSeatPosition and seat.cameras[2].isInside then
                    vehicleInfo.seats[s].insideCamera = {}

                    if seat.insideCameraLinkNode == nil then
                        vehicleInfo.seats[s].insideCamera.position = UP_Creator.getRoundedTrans(seat.cameras[2].rotateNode, 3, true)
                    else
                        local position = {localToLocal(seat.cameras[2].rotateNode, vehicle.components[1].node, 0, 0, 0)}

                        vehicleInfo.seats[s].insideCameraLinkNodeOffset = true
                        vehicleInfo.seats[s].insideCamera.position = UP_Creator.getRoundedTable(position, 3, false, true)
                    end

                    vehicleInfo.seats[s].insideCamera.rotation = UP_Creator.getRoundedRot(seat.cameras[2].rotateNode, nil, true)
                end

                local characterChanges = self:getCharacterChanges(vehicle.configFileName, seat, s, false)

                if characterChanges ~= nil then
                    vehicleInfo.seats[s].passengerCharacter = characterChanges
                end

                vehicleInfo.seats[s].zSpineRotation = MathUtil.round(math.deg(seat.passengerCharacter.characterSpineRotation[3]))

                if seat.partChange ~= nil then
                    ignorePartsChangeMin = ignorePartsChangeMin == nil or loadAddons:lower() == "true"
                    vehicleInfo.seats[s].partChange = self:collectPartsInfo(seat.partChange, ignorePartsChangeMin)
                end

                if seat.passengerEnterAnimation ~= nil then
                    vehicleInfo.seats[s].enterAnimation = seat.passengerEnterAnimation
                end
            end

            table.insert(self.vehicleInfo, vehicleInfo)
        end

        forceCreateXML = Utils.stringToBoolean(forceCreateXML)

        if forceCreateXML then
            local returnText = "INFO: Force creating XML now. Please wait."

            return self:consoleCommandCreatePassengerSeatsXML(returnText)
        else
            return "INFO: Vehicle passenger seat(s) have been saved for (" .. tostring(#self.vehicleInfo) .. ") vehicles."
        end
    end
end

function UP_Creator.collectScenegraphInfoRec(node, level, info, index, i3dMappings)
    local indent = ""
    local name = "..."

    info = info or {text = ""}

    if index == nil then
        UP_Creator.scenegraphIndex[node] = string.format("%.0f>", getChildIndex(node))
    else
        if index:sub(-1) ~= ">" then
            UP_Creator.scenegraphIndex[node] = string.format("%s|%.0f", index, getChildIndex(node))
        else
            UP_Creator.scenegraphIndex[node] = string.format("%s%.0f", index, getChildIndex(node))
        end
    end

    if i3dMappings ~= nil then
        local newIndex = UP_Creator.scenegraphIndex[node]

        for i3dMapping, index in pairs (i3dMappings) do
            if index == newIndex then
                name = i3dMapping
                break
            end
        end
    end

    for i = 1, level do
        indent = indent .. "    "
    end

    info.text = string.format("%s%s%s ( %d ) | %s ( %s ) | Visible: %s\n", info.text, indent, getName(node), node, name, UP_Creator.scenegraphIndex[node], tostring(getVisibility(node)))

    local num = getNumOfChildren(node)

    for i = 0, num - 1 do
        UP_Creator.collectScenegraphInfoRec(getChildAt(node, i), level + 1, info, UP_Creator.scenegraphIndex[node], i3dMappings)
    end
end

function UP_Creator:consoleCommandExportI3dMappings(printToLog)
    local vehicle = g_universalPassenger.currentPassengerSeatId ~= nil and g_universalPassenger.currentPassengerVehicle or nil

    if vehicle ~= nil then
        if vehicle.i3dMappings ~= nil and ListUtil.size(vehicle.i3dMappings) > 0 then
            if Utils.stringToBoolean(printToLog) then
                setFileLogPrefixTimestamp(false)

                print("---------------------------------- < " .. tostring(vehicle.i3dFilename) .. " | i3D Mappings Print > ----------------------------------", "", "<i3dMappings>")

                for name, index in pairs (vehicle.i3dMappings) do
                    print('    <i3dMapping id="' .. tostring(name) .. '" node="' .. tostring(index) .. '"/>')
                end

                print("</i3dMappings>", "---------------------------------- < " .. tostring(vehicle.i3dFilename) .. " | i3D Mappings Print > ----------------------------------", "")

                setFileLogPrefixTimestamp(true)
            else
                local i3dFilename = vehicle.i3dFilename
                local st, _ = i3dFilename:find("/[^/]*$")

                if st ~= nil then
                    i3dFilename = i3dFilename:sub(st + 1)
                end

                local filename = g_modsDirectory .. string.gsub(i3dFilename, ".i3d", "_i3dMappings.xml")
                local fileId = createFile(filename, FileAccess.WRITE)

                local mappings = '<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n\n<i3dMappings>\n'

                for name, index in pairs (vehicle.i3dMappings) do
                    mappings = mappings .. '    <i3dMapping id="' .. tostring(name) .. '" node="' .. tostring(index) .. '"/>\n'
                end

                mappings = mappings .. '</i3dMappings>\n'

                fileWrite(fileId, mappings)
                delete(fileId)

                return "Success, I3D XML file created at " .. filename
            end

            delete(rootNode)
        else
            return "  Info: No I3dMappings found for this vehicle!"
        end
    else
        return "  Info: Export / Print failed, first enter the vehicle as a passenger!"
    end
end

function UP_Creator:consoleCommandExportScenegraph(printToLog, graphviz)
    local vehicle = g_universalPassenger.currentPassengerSeatId ~= nil and g_universalPassenger.currentPassengerVehicle or nil

    if vehicle ~= nil then
        local i3dFilename = tostring(vehicle.i3dFilename)
        local vehicleModName = vehicle.customEnvironment or ""
        local rootNode = g_i3DManager:loadSharedI3DFile(i3dFilename, vehicle.baseDirectory, false, false, false)

        if rootNode ~= nil and rootNode ~= 0 then
            if Utils.stringToBoolean(graphviz) then
                local st, _ = i3dFilename:find("/[^/]*$")

                if st ~= nil then
                    i3dFilename = i3dFilename:sub(st + 1)
                end

                local filename = string.format("%s%s_%s", g_modsDirectory, vehicleModName, string.gsub(i3dFilename, ".i3d", "_scenegraph.gv"))
                exportScenegraphToGraphviz(rootNode, filename)

                return "Success, Graphviz file created at " .. filename
            else
                if Utils.stringToBoolean(printToLog) then
                    setFileLogPrefixTimestamp(false)
                    print("---------------------------------- < " .. i3dFilename .. " | Scenegraph Print > ----------------------------------", "")

                    printScenegraph(rootNode, false)

                    print("---------------------------------- < " .. i3dFilename .. " | Scenegraph Print > ----------------------------------", "")
                    setFileLogPrefixTimestamp(true)
                else
                    local st, _ = i3dFilename:find("/[^/]*$")

                    if st ~= nil then
                        i3dFilename = i3dFilename:sub(st + 1)
                    end

                    local filename = string.format("%s%s_%s", g_modsDirectory, vehicleModName, string.gsub(i3dFilename, ".i3d", "_scenegraph.txt"))
                    local fileId = createFile(filename, FileAccess.WRITE)

                    local info = {text = string.format("%s ( %d ) | Scenegraph Root\n\n", getName(rootNode), rootNode)}
                    UP_Creator.scenegraphIndex = {}
                    UP_Creator.collectScenegraphInfoRec(getChildAt(rootNode, 0), 0, info, nil, vehicle.i3dMappings)
                    UP_Creator.scenegraphIndex = nil

                    fileWrite(fileId, info.text)
                    delete(fileId)

                    return "Success, Scenegraph Info XML file created at " .. filename
                end
            end

            delete(rootNode)
        end
    else
        return "  Info: Export / Print failed, first enter the vehicle as a passenger!"
    end

    return
end

function UP_Creator:consoleCommandClearVehicleInfoTable()
    self.vehicleInfo = nil
    return "INFO: Vehicle Info Table has been cleared."
end

function UP_Creator:consoleCommandReloadStandardVehicleList()
    self:loadVehicleList()
    return "INFO: List reloaded successfully."
end

function UP_Creator:consoleCommandReloadGlobalVehicleFiles(loadAddons, reloadVehicle)
    if g_universalPassenger:loadGlobalXMLFiles(loadAddons == nil or loadAddons:lower() == "true", true, true) then
        if Utils.stringToBoolean(reloadVehicle) then
            if g_universalPassenger.currentPassengerVehicle ~= nil then
                g_universalPassenger:actionEventMoveToDriverSeat()
                g_currentMission:consoleCommandReloadVehicle("false")
            else
                return "  Info: Reloading of vehicle failed, first enter the vehicle as a passenger!"
            end
        end
    end

    return
end

function UP_Creator:consoleCommandCreateListFromVehicleCategory(categoryName, forceCreateXML, useSeatZ)
    local duplicateCount = 0
    local category = g_storeManager:getCategoryByName(categoryName)

    self.vehicleList = {}

    if category ~= nil then
        useSeatZ = Utils.stringToBoolean(useSeatZ) -- Move the camera `z` position in line with the player TG if true.

        local function getCanAddVehicle(xmlFilename)
            for _, addedVehicle in pairs (self.vehicleList) do
                if addedVehicle.xmlFilename == xmlFilename then
                    duplicateCount = duplicateCount + 1

                    return false
                end
            end

            return true
        end

        for _, storeItem in pairs(g_storeManager:getItems()) do
            if storeItem.categoryName == category.name then
                if not storeItem.isBundleItem and storeItem.showInStore and storeItem.bundleInfo == nil then
                    if getCanAddVehicle(storeItem.xmlFilename) then
                        table.insert(self.vehicleList, {
                            xmlFilename = storeItem.xmlFilename,
                            useSeatZ = useSeatZ
                        })
                    end
                elseif storeItem.bundleInfo ~= nil and storeItem.bundleInfo.bundleItems ~= nil then
                    for _, item in pairs(storeItem.bundleInfo.bundleItems) do
                        if getCanAddVehicle(item.xmlFilename) then
                            table.insert(self.vehicleList, {
                                xmlFilename = item.xmlFilename,
                                useSeatZ = useSeatZ
                            })
                        end
                    end
                end
            end
        end

        local returnText = ""

        if duplicateCount > 0 then
            returnText = returnText .. "\nWARNING: " .. tostring(duplicateCount) .. " duplicate spawned steerable vehicle(s) skipped."
        end

        if Utils.stringToBoolean(forceCreateXML) then
            returnText = returnText .. "\nINFO: Force creating XML now. Please wait."

            return self:consoleCommandCreatePassengerSeatsFromList(nil, returnText, true, category.name)
        else
            returnText = returnText .. "\n" .. tostring(#self.vehicleList) .. " steerable vehicles added to the list."

            return returnText
        end
    end

    if categoryName ~= nil then
        return "WARNING: No valid category with name " .. tostring(categoryName):upper() .. " found!"
    else
        return "WARNING: No category given!"
    end
end

function UP_Creator:consoleCommandCreateListFromSpawnedVehicles(forceCreateXML, useSeatZ)
    local duplicateCount = 0

    self.vehicleList = {}

    for _, enterable in pairs(g_currentMission.enterables) do
        local canAdd = true

        for _, addedVehicle in pairs (self.vehicleList) do
            if addedVehicle.xmlFilename == enterable.configFileName then
                canAdd = false
                duplicateCount = duplicateCount + 1
                break
            end
        end

        if canAdd then
            local vehicle = {
                xmlFilename = enterable.configFileName,
                useSeatZ = Utils.stringToBoolean(useSeatZ) -- Move the camera `z` position in line with the player TG if true.
            }

            table.insert(self.vehicleList, vehicle)
        end
    end

    local returnText = ""

    if duplicateCount > 0 then
        returnText = returnText .. "\nWARNING: " .. tostring(duplicateCount) .. " duplicate spawned steerable vehicle(s) skipped."
    end

    if Utils.stringToBoolean(forceCreateXML) then
        returnText = returnText .. "\nINFO: Force creating XML now. Please wait."

        return self:consoleCommandCreatePassengerSeatsFromList(nil, returnText)
    else
        returnText = returnText .. "\n" .. tostring(#self.vehicleList) .. " steerable vehicles added to the list."

        return returnText
    end
end

function UP_Creator:consoleCommandPrintSupportedModList(printModName, printDescriptionInfo)
    if g_universalPassenger ~= nil and g_universalPassenger.xmlFilenameToModName ~= nil then
        local xmlPath
        local validMods = {
            ["FS19_UniversalPassenger_VehiclesOfModHub"] = true,
            ["FS19_UniversalPassenger_VehiclesOfModHub_update"] = true
        }

        for path, customEnvironment in pairs (g_universalPassenger.xmlFilenameToModName) do
            if validMods[customEnvironment] then
                xmlPath = path
                break
            end
        end

        if xmlPath ~= nil and fileExists(xmlPath) then
            local xmlFile = loadXMLFile("universalPassengerXML", xmlPath)

            if hasXMLProperty(xmlFile, "universalPassengerVehicles") then
                local descriptionInfo
                local printedModVehicles = {}
                local notLoaded = {}

                printModName = Utils.stringToBoolean(printModName)
                printDescriptionInfo = Utils.stringToBoolean(printDescriptionInfo)

                setFileLogPrefixTimestamp(false)
                if printDescriptionInfo then
                    descriptionInfo = {}

                    print("---------------------------------- < Description Info > ----------------------------------", "")
                else
                    print("---------------------------------- < Supported Mod Vehicle List > ----------------------------------", "")
                end

                local i = 0
                while true do
                    local key = string.format("universalPassengerVehicles.vehicle(%d)", i)
                    if not hasXMLProperty(xmlFile, key) then
                        break
                    end

                    local modName = getXMLString(xmlFile, key .. "#modName")

                    if Utils.getNoNil(getXMLBool(xmlFile, key .. "#pdlc"), false) then
                        modName = g_uniqueDlcNamePrefix .. modName
                    end

                    local mod = g_modManager:getModByName(modName)


                    if mod ~= nil then
                        local version = Utils.getNoNil(Utils.getNoNil(getXMLString(xmlFile, key .. "#version"), mod.version))
                        local id = modName .. "_V" ..  version

                        if printedModVehicles[id] == nil then
                            printedModVehicles[id] = true

                            if printDescriptionInfo then
                                local modFile = loadXMLFile("ModDesc", mod.modFile)
                                local default = getXMLString(modFile, "modDesc.title.en") or "( " .. modName .. " )"

                                table.insert(descriptionInfo, {
                                    default = utf8ToUpper(default),
                                    en = string.format("  - %s [v%s] - %s", default, version, mod.author),
                                    de = string.format("  - %s [v%s] - %s", getXMLString(modFile, "modDesc.title.de") or default, version, mod.author),
                                    fr = string.format("  - %s [v%s] - %s", getXMLString(modFile, "modDesc.title.fr") or default, version, mod.author)
                                })

                                delete(modFile)
                            else
                                if printModName then
                                    print(string.format("  - %s [V%s] - %s (%s)", mod.title, version, mod.author, modName))
                                else
                                    print(string.format("  - %s [V%s] - %s", mod.title, version, mod.author))
                                end
                            end
                        end
                    elseif not Utils.getNoNil(getXMLBool(xmlFile, key .. "#consoleNameDuplicate"), false) then
                        local version = Utils.getNoNil(getXMLString(xmlFile, key .. "#version"), "0.0.0.0")
                        local notLoadedText = string.format("  - (Not Loaded: %s [V%s])", modName, version)

                        -- print(notLoadedText)
                        table.insert(notLoaded, notLoadedText)
                    end

                    i = i + 1
                end

                if descriptionInfo ~= nil and #descriptionInfo > 0 then
                    table.sort(descriptionInfo, function(data1, data2)
                        return data1.default < data2.default
                    end)

                    for _, languageShort in ipairs ({"en", "de", "fr"}) do
                        print("", string.format("%s Description:", languageShort:upper()), "")

                        for _, data in ipairs (descriptionInfo) do
                            print(data[languageShort] or "  - Language error!")
                        end

                        print("")
                    end
                end

                if #notLoaded > 0 then
                    print("", string.format("Total mods not loaded: %s", #notLoaded))

                    for _, notLoadedText in pairs (notLoaded) do
                        print(notLoadedText)
                    end
                end

                if printDescriptionInfo then
                    print("", "---------------------------------- < Description Info > ----------------------------------")
                else
                    print("", "---------------------------------- < Supported Mod Vehicle List > ----------------------------------")
                end

                setFileLogPrefixTimestamp(true)

                return
            else
                self:logPrint(UniversalPassenger.LOG_ERROR, "XML Property 'universalPassengerVehicles' not found in '%s'.", xmlPath)
            end

            delete(xmlFile)
        end
    end

    return "Failed to create list!"
end

function UP_Creator:consoleCommandCreatePassengerSeatsFromList(useSeatZ, returnText, categoryCount, categoryName)
    if g_currentMission:getIsServer() and not g_currentMission.missionDynamicInfo.isMultiplayer then
        if returnText == nil then
            returnText = ""
        end

        if self.vehicleList == nil or #self.vehicleList <= 0 then
            returnText = returnText .. "\nINFO: Vehicle List table is nil or empty!"

            return returnText
        end

        self.content = ''
        self.raycastNodeErrors = 0
        self.listActive = true
        self.numVehiclesLoaded = 0

        for i = 1, #self.vehicleList do
            if self.vehicleList[i].useSeatZ == nil then
                self.vehicleList[i].useSeatZ = Utils.stringToBoolean(useSeatZ)
            end

            local vehicle = g_currentMission:loadVehicle(self.vehicleList[i].xmlFilename, 0, nil, 0, 0, 0, true, 0, Vehicle.PROPERTY_STATE_NONE, nil, nil, nil)

            if vehicle ~= nil then
                g_currentMission:removeVehicle(vehicle)
            end
        end

        returnText = returnText .. "\nINFO: Success! XML has been saved at " .. g_modsDirectory

        local categoryData

        if self.isDev and categoryCount == true and categoryName ~= nil then
            categoryName = tostring(categoryName)
            categoryData = '    <!-- ****** ' .. categoryName .. ' - ' .. tostring(self.numVehiclesLoaded) .. ' ****** -->'

            returnText = returnText .. "\nDEV INFO: " .. tostring(self.numVehiclesLoaded) .. " vehicles loaded from category '" .. categoryName .. "'."
        end

        self:writeXML(g_modsDirectory .. "universalPassengerCreator.xml", categoryData)

        self.numVehiclesLoaded = nil

        return returnText
    end
end

function UP_Creator:consoleCommandCreatePassengerSeatsXML(returnText)
    if g_currentMission:getIsServer() and not g_currentMission.missionDynamicInfo.isMultiplayer then
        if returnText == nil then
            returnText = ""
        end

        if self.vehicleInfo == nil then
            return returnText .. "\nINFO: No vehicle info has been saved. This can be done using 'upStorePassengerSeat' or 'upStoreAllPassengerSeats' \nSupport: https://forum.giants-software.com  or  https://github.com/GtX-Andy"
        end

        self.content = ''
        self.raycastNodeErrors = 0
        self.infoActive = true

        for i = 1, #self.vehicleInfo do
            local vehicle = g_currentMission:loadVehicle(self.vehicleInfo[i].xmlFilename, 0, nil, 0, 0, 0, true, 0, Vehicle.PROPERTY_STATE_NONE, nil, nil, nil)

            if vehicle ~= nil then
                g_currentMission:removeVehicle(vehicle)
            end
        end

        self:writeXML(g_modsDirectory .. "universalPassengerCreator.xml")

        return returnText .. "\nINFO: Success! XML has been saved at " .. g_modsDirectory
    end
end

function UP_Creator.collectXmlData(vehicle, vehicleData, asyncCallbackFunction, asyncCallbackObject, asyncCallbackArguments)
    if g_universalPassenger == nil or g_universalPassenger.creator == nil or not g_universalPassenger.creator.active then
        return
    end

    local upc = g_universalPassenger.creator

    if upc.listActive or upc.infoActive then
        local gp, canCollect = nil, false

        if upc.listActive then
            for v = 1, #upc.vehicleList do
                if vehicle.configFileName == upc.vehicleList[v].xmlFilename then
                    if upc.vehicleList[v].seats == nil then
                        upc.vehicleList[v].seats = {}

                        local seat = {}

                        if upc.vehicleList[v].position == nil then
                            seat = upc:getDriverPosition(vehicle, vehicle.xmlFile, vehicle.components[1].node)
                            seat.passengerCharacter = {
                                '                <leftFoot position="0.11 -0.52 0.374" rotation="0 0 0"/>\n',
                                '                <rightFoot position="-0.083 -0.52 0.392" rotation="0 0 0"/>\n',
                                '                <rightArm position="-0.05 0.1 0.36" rotation="-29.528 90.641 -27.006"/>\n',
                                '                <leftArm position="0.08 0.07 0.36" rotation="-101.15 -93.193 90.437" poseId="flatFingers"/>\n',
                            }

                            seat.isInside = true
                            seat.useMirror = true
                            seat.useOutdoorSounds = false
                        else
                            seat.position = upc.vehicleList[v].position

                            if upc.vehicleList[v].rotation ~= nil then
                                seat.rotation = upc.vehicleList[v].rotation
                            end
                        end

                        table.insert(upc.vehicleList[v].seats, seat)
                    end

                    gp = upc.vehicleList[v]

                    canCollect = true
                    break
                end
            end
        elseif upc.infoActive then
            for v = 1, #upc.vehicleInfo do
                if vehicle.configFileName == upc.vehicleInfo[v].xmlFilename then
                    if upc.vehicleInfo[v].seats == nil then
                        if upc.vehicleInfo[v].position ~= nil then
                            local seat = {}
                            seat.position = upc.vehicleInfo[v].position
                            if upc.vehicleInfo[v].rotation ~= nil then
                                seat.rotation = upc.vehicleInfo[v].rotation
                            end

                            table.insert(upc.vehicleInfo[v], seat)
                        else
                            canCollect = false
                        end
                    end

                    gp = upc.vehicleInfo[v]
                    canCollect = true

                    break
                end
            end
        end

        if canCollect then
            local content = '    <vehicle xmlFilename="' .. gp.xmlFilename .. '">\n'

            if vehicle.customEnvironment ~= nil then
                local modInfo = ''
                local version = ''

                local xmlFilename = gp.xmlFilename
                local customEnvironment = vehicle.customEnvironment

                local pdlc = ''
                local prefix = g_uniqueDlcNamePrefix or "pdlc_"

                if StringUtil.startsWith(customEnvironment, prefix) then
                    customEnvironment = customEnvironment:sub(#prefix + 1)
                    pdlc = ' pdlc="true"'
                end

                if g_modNameToDirectory ~= nil and g_modNameToDirectory[vehicle.customEnvironment] ~= nil then
                    xmlFilename = xmlFilename:sub(#g_modNameToDirectory[vehicle.customEnvironment] + 1)
                else
                    local _, e = xmlFilename:find(customEnvironment)
                    xmlFilename = xmlFilename:sub(e + 2)
                end

                if upc.writeModInfo then
                    local mod = g_modManager:getModByName(customEnvironment)

                    if mod ~= nil and mod.author ~= nil and mod.version ~= nil then
                        version = ' version="' .. tostring(mod.version) .. '"'
                        modInfo = '    <!-- ' .. tostring(customEnvironment) ..' - V' .. tostring(mod.version) ..' - ' .. tostring(mod.author) ..' -->\n'
                    end
                end

                content = modInfo .. '    <vehicle xmlFilename="' .. xmlFilename .. '" modName="' .. customEnvironment .. '"' .. pdlc .. version .. '>\n'
            end

            for index, seat in pairs (gp.seats) do
                local outsideCameraLinkNode = vehicle.components[1].node
                -- local insideCameraLinkNode

                local positionToTable = StringUtil.splitString(" ", seat.position)
                local gpx, gpy, gpz = positionToTable[1], positionToTable[2], positionToTable[3]

                local xmlFile = vehicle.xmlFile

                content = content .. '        <passenger'

                if seat.characterLinkNodeStr ~= nil then
                    content = content .. ' characterLinkNode="' .. seat.characterLinkNodeStr .. '"'
                end

                if seat.outsideCameraLinkNodeStr ~= nil then
                    content = content .. ' outsideCameraLinkNode="' .. seat.outsideCameraLinkNodeStr .. '"'
                    outsideCameraLinkNode = I3DUtil.indexToObject(vehicle.components, seat.outsideCameraLinkNodeStr, vehicle.i3dMappings)
                end

                if seat.insideCameraLinkNodeStr ~= nil then
                    content = content .. ' insideCameraLinkNode="' .. seat.insideCameraLinkNodeStr .. '"'
                    -- insideCameraLinkNode = I3DUtil.indexToObject(vehicle.components, seat.insideCameraLinkNodeStr, vehicle.i3dMappings)
                end

                if seat.characterLinkNodeOffset == true or seat.insideCameraLinkNodeOffset == true then
                    content = content .. ' positionsFromComponent1="true"'
                    -- insideCameraLinkNode = vehicle.components[1].node
                end

                if seat.exitNodePositionStr ~= nil then
                    content = content .. ' exitNodePosition="' .. seat.exitNodePositionStr .. '"'
                end

                content = content .. '>\n'

                local rotationContent = ''

                if seat.rotation ~= nil then
                    rotationContent = ' rotation="' .. seat.rotation .. '"'
                end

                local spineRotation = ' spineRotation="-90 0 90"'
                if seat.zSpineRotation ~= nil then
                    spineRotation = ' spineRotation="-90 0 ' .. seat.zSpineRotation ..'"'
                end

                local passengerCharacter = ''
                if seat.passengerCharacter ~= nil then
                    content = content .. '            <passengerNode position="' .. seat.position .. '"' .. rotationContent .. spineRotation ..' customTargets="true">\n'
                    for _, xmlProp in pairs (seat.passengerCharacter) do
                        content = content .. xmlProp
                    end
                    content = content .. '            </passengerNode>\n\n'
                else
                    content = content .. '            <passengerNode position="' .. seat.position .. '"' .. rotationContent .. spineRotation ..' customTargets="false"/>\n\n'
                end

                content = content .. '            <cameras>\n'

                local cam = 0
                while true do
                    local key = string.format("vehicle.enterable.cameras.camera(%d)", cam)
                    if not hasXMLProperty(xmlFile, key) then
                        break
                    end

                    local node = I3DUtil.indexToObject(vehicle.components, getXMLString(xmlFile, key .. "#node"), vehicle.i3dMappings)

                    if cam == 0 then
                        local cameraPosition = getXMLString(xmlFile, key .. "#translation")
                        local cameraRotation = ''

                        local rotateNodePosition = '0 0 0'
                        local rotateNodeRotation = ''

                        local worldXZRotation = ''

                        local isRotatable = Utils.getNoNil(getXMLBool(xmlFile, key .. "#rotatable"), true)
                        local limit = Utils.getNoNil(getXMLBool(xmlFile, key .. "#limit"), true)

                        if isRotatable then
                            local rotateNode = I3DUtil.indexToObject(vehicle.components, getXMLString(xmlFile, key .. "#rotateNode"), vehicle.i3dMappings)

                            rotateNodePosition = UP_Creator.getRoundedTrans(rotateNode, 3, true, outsideCameraLinkNode)

                            local rotation = getXMLString(xmlFile, key .. "#rotation")

                            if rotation == nil then
                                rotation = UP_Creator.getRoundedRot(rotateNode, 3, true)

                                if upc.getCameraRotationFromI3D then
                                    local rx, ry, rz = UP_Creator.getRoundedRot(node, 0, false)

                                    if rx ~= 0 or ry ~= 0 or rz ~= 0 then
                                        cameraRotation = ' cameraRotation="' .. rx .. ' ' .. ry .. ' ' .. rz .. '"'
                                    end
                                end
                            end

                            if rotation ~= nil then
                                rotateNodeRotation = ' rotateNodeRotation="' .. rotation .. '"'
                            end
                        end

                        local useWorldXZRotation = getXMLBool(xmlFile, key .. "#useWorldXZRotation")

                        if useWorldXZRotation ~= nil then
                            worldXZRotation = ' useWorldXZRotation="' .. tostring(useWorldXZRotation) .. '"'
                        end

                        if cameraPosition == nil then
                            cameraPosition = UP_Creator.getRoundedTrans(node, 3, true)
                        end

                        content = content .. '                <camera cameraPosition="' .. cameraPosition .. '"' .. cameraRotation
                        content = content .. ' rotateNodePosition="' .. rotateNodePosition .. '"' .. rotateNodeRotation .. ' rotatable="' .. tostring(isRotatable) .. '" limit="' .. tostring(limit) .. '"' .. worldXZRotation

                        if limit then
                            local rotMinX = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#rotMinX"), 3, -1.4)
                            local rotMaxX = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#rotMaxX"), 3, 1)
                            local transMin = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#transMin"), 3, 4)
                            local transMax = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#transMax"), 3, 35)

                            content = content .. ' rotMinX="' .. rotMinX .. '" rotMaxX="' .. rotMaxX .. '" transMin="' .. transMin .. '" transMax="' .. transMax .. '"'
                        end

                        local raycastNodeContent = ''
                        local raycastNodeWarning = ''

                        local c = 0
                        while true do
                            local raycastKey = string.format("%s.raycastNode(%d)", key, c)
                            if not hasXMLProperty(xmlFile, raycastKey) then
                                break
                            end

                            local raycastNode = I3DUtil.indexToObject(vehicle.components, getXMLString(xmlFile, raycastKey .. "#node"), vehicle.i3dMappings)

                            if raycastNode ~= nil then
                                local Nx, Ny, Nz = UP_Creator.getRoundedTrans(raycastNode, 3, false, outsideCameraLinkNode)
                                local NxR, NyR, NzR = UP_Creator.getRoundedRot(raycastNode, 3, false, outsideCameraLinkNode)

                                if Nx == 0 and Ny == 0 and Nz == 0 then
                                    raycastNodeWarning = '                    <!-- IMPORTANT: Positions should be checked, 0 0 0 is not a suitable location for a raycastNode. -->\n'
                                    upc.raycastNodeErrors = upc.raycastNodeErrors + 1
                                end

                                if NxR == 0 and NyR == 0 and NzR == 0 then
                                    raycastNodeContent = raycastNodeContent .. '                    <raycastNode position="' .. Nx .. ' ' .. Ny .. ' ' .. Nz .. '"/>\n'
                                else
                                    raycastNodeContent = raycastNodeContent .. '                    <raycastNode position="' .. Nx .. ' ' .. Ny .. ' ' .. Nz .. '" rotation="' .. NxR .. ' ' .. NyR .. ' ' .. NzR .. '"/>\n'
                                end
                            end

                            c = c + 1
                        end

                        if raycastNodeContent ~= '' then
                            content = content .. '>\n' .. raycastNodeWarning .. raycastNodeContent .. '                </camera>\n'
                        else
                            content = content .. '/>\n'
                        end
                    else
                        local x, y, z = UP_Creator.getRoundedTrans(node, 3)

                        if gp.useSeatZ then
                            z = gpz
                        end

                        local position = 'cameraPosition="' .. gpx .. ' ' .. y .. ' ' .. z .. '"'

                        local rx, ry, rz = UP_Creator.getRoundedRot(node, 0, false)
                        if rz ~= 0 then
                            local insideCamRotation = getXMLString(xmlFile, key .. "#rotation")

                            if insideCamRotation ~= nil then
                                rotation = ' cameraRotation="' .. insideCamRotation .. '"'
                            else
                                rotation = ' cameraRotation="-15 180 0"'
                            end
                        else
                            rotation = ' cameraRotation="' .. rx .. ' ' .. ry .. ' ' .. rz .. '"'
                        end

                        if seat.insideCamera ~= nil then
                            if seat.insideCamera.position ~= nil then
                                position = 'cameraPosition="' .. seat.insideCamera.position .. '"'
                                if seat.insideCamera.rotation ~= nil then
                                    rotation = ' cameraRotation="' .. seat.insideCamera.rotation .. '"'
                                end
                            end
                        end

                        local isRotatable = tostring(Utils.getNoNil(getXMLBool(xmlFile, key .. "#rotatable"), true))
                        local limit = tostring(Utils.getNoNil(getXMLBool(xmlFile, key .. "#limit"), true))

                        local useWorldXZRotation = getXMLBool(xmlFile, key .. "#useWorldXZRotation")
                        local worldXZRotation = ""

                        if useWorldXZRotation ~= nil then
                            worldXZRotation = ' useWorldXZRotation="' .. tostring(useWorldXZRotation) .. '"'
                        end

                        local rotMinX = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#rotMinX"), 3, -1.4)
                        local rotMaxX = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#rotMaxX"), 3, 0.4)
                        local transMin = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#transMin"), 3, 0)
                        local transMax = UP_Creator.noNilRound(getXMLFloat(xmlFile, key .. "#transMax"), 3, 0)

                        local isInside, useMirror, useOutdoorSounds = ' allowHeadTracking="true"', ' useMirror="false"', ''

                        if seat.isInside then
                            isInside = ' isInside="true"'
                        end

                        if seat.useMirror then
                            useMirror = ' useMirror="true"'
                        end

                        if seat.useOutdoorSounds then
                            useOutdoorSounds = ' useOutdoorSounds="true"'
                        end

                        content = content .. '                <camera ' .. position .. rotation .. ' rotatable="' .. isRotatable .. '" limit="' .. limit .. '"'
                        content = content .. worldXZRotation .. ' rotMinX="' .. rotMinX .. '" rotMaxX="' .. rotMaxX .. '" transMin="' .. transMin .. '" transMax="' .. transMax .. '"' .. useMirror .. isInside .. useOutdoorSounds .. '/>\n'

                        break
                    end

                    cam = cam + 1
                end

                content = content .. '            </cameras>\n'

                if seat.partChange ~= nil then
                    content = content .. seat.partChange
                end

                if seat.enterAnimation ~= nil then
                    content = content .. '\n            <enterAnimation name="' ..seat.enterAnimation.. '"/>\n'
                end

                content = content .. '        </passenger>\n'
            end

            content = content .. '    </vehicle>\n\n'

            upc.content = upc.content .. content

            if upc.isDev and upc.numVehiclesLoaded ~= nil then
                upc.numVehiclesLoaded = upc.numVehiclesLoaded + 1
            end
        end
    end
end

function UP_Creator:getTransRotXYZPrint(seat)
    local i3dCharacterNode = seat.creatorInfo ~= nil and seat.creatorInfo.i3dCharacterNode or nil

    if i3dCharacterNode == nil then
        return "Failed to find 'i3dCharacterNode'!"
    end

    local spineRotZ = MathUtil.round(math.deg(seat.passengerCharacter.characterSpineRotation[3]), 3)
    local passengerTrans = string.format("Passenger %s NodePosition = %s", seat.id, UP_Creator.getRoundedTrans(i3dCharacterNode, 3, true))
    local passengerRot = string.format("Passenger %s NodeRotation = %s", seat.id, UP_Creator.getRoundedRot(i3dCharacterNode, 3, true))
    local passengerSpineRot = string.format("Passenger %s XML SpineRotation = -90 0 %s", seat.id, spineRotZ)
    local cameraTrans = string.format("Passenger %s Camera(2) Position = %s", seat.id, UP_Creator.getRoundedTrans(seat.cameras[2].rotateNode, 3, true))
    local cameraRot = string.format("Passenger %s Camera(2) Rotation = %s", seat.id, UP_Creator.getRoundedRot(seat.cameras[2].rotateNode, 0, true))

    return string.format("\n%s\n%s\n%s\n\n%s\n%s\n", passengerTrans, passengerRot, passengerSpineRot, cameraTrans, cameraRot)
end

function UP_Creator:getCharacterChanges(filename, seat, seatId, printReturn)
    local changed = false
    local changesTable = nil

    if filename ~= nil and seat ~= nil then
        filename = filename:lower()
        if self.vehicles[filename] ~= nil then
            for targetId, target in pairs (seat.passengerCharacter.ikChainTargets) do
                if self.vehicles[filename][seatId] ~= nil and self.vehicles[filename][seatId].targetNodes[targetId] ~= nil then
                    local x, y, z = getTranslation(target.targetNode)
                    local position = string.format("%s %s %s", x, y, z)
                    local rx, ry, rz = getRotation(target.targetNode)
                    local rotation = string.format("%s %s %s", rx, ry, rz)

                    if position ~= self.vehicles[filename][seatId].targetNodes[targetId].trans or rotation ~= self.vehicles[filename][seatId].targetNodes[targetId].rot then
                        changed = true

                        break
                    end
                end
            end
        end
    end

    if changed or seat.passengerCharacter.hasCustomTargets then
        changesTable = {}

        for targetId, target in pairs (seat.passengerCharacter.ikChainTargets) do
            local position = UP_Creator.getRoundedTrans(target.targetNode, 3, true)
            local rotation = UP_Creator.getRoundedRot(target.targetNode, 3, true)

            local poseId = ""
            if seat.passengerCharacter.poseIds ~= nil then
                poseId = seat.passengerCharacter.poseIds[targetId] or ""
                if poseId == "narrowFingers" then
                    poseId = ""
                end
            end

            if printReturn then
                changesTable[targetId] = {position = position, rotation = rotation, poseId = poseId}
            else
                if poseId ~= "" then
                    poseId = ' poseId="' .. poseId .. '"'
                end

                changesTable[targetId] = '                <' .. targetId .. ' position="' .. position .. '" rotation="' .. rotation .. '"' .. poseId ..'/>\n'
            end
        end
    end

    return changesTable
end

function UP_Creator:collectPartsInfo(partChange, ignoreMin)
    if partChange ~= nil then
        local part = '\n            <partChange index="' .. partChange.indexString .. '"'
        local validName = partChange.validName or getName(partChange.index)

        if validName ~= nil then
            part = part .. ' validName="' .. tostring(validName) .. '"'
        end

        local x1, y1, z1 = UP_Creator.getRoundedTable(partChange.transMin, 3, false)
        local x2, y2, z2 = UP_Creator.getRoundedTable(partChange.transMax, 3, false)

        if x1 ~= x2 or y1 ~= y2 or z1 ~= z2 then
            if ignoreMin then
                part = part .. ' transMax="' .. x2 .. ' ' .. y2 .. ' ' .. z2 .. '"'
            else
                part = part .. ' transMin="' .. x1 .. ' ' .. y1 .. ' ' .. z1 .. '" transMax="' .. x2 .. ' ' .. y2 .. ' ' .. z2 .. '"'
            end
        end

        x1, y1, z1 = UP_Creator.getRoundedTable(partChange.rotMin, 3, true)
        x2, y2, z2 = UP_Creator.getRoundedTable(partChange.rotMax, 3, true)

        if x1 ~= x2 or y1 ~= y2 or z1 ~= z2 then
            if ignoreMin then
                part = part .. ' rotMax="' .. x2 .. ' ' .. y2 .. ' ' .. z2 .. '"'
            else
                part = part .. ' rotMin="' .. x1 .. ' ' .. y1 .. ' ' .. z1 .. '" rotMax="' .. x2 .. ' ' .. y2 .. ' ' .. z2 .. '"'
            end
        end

        x1, y1, z1 = UP_Creator.getRoundedTable(partChange.scaleMin, 3, false)
        x2, y2, z2 = UP_Creator.getRoundedTable(partChange.scaleMax, 3, false)

        if x1 ~= x2 or y1 ~= y2 or z1 ~= z2 then
            if ignoreMin then
                part = part .. ' scaleMax="' .. x2 .. ' ' .. y2 .. ' ' .. z2 .. '"'
            else
                part = part .. ' scaleMin="' .. x1 .. ' ' .. y1 .. ' ' .. z1 .. '" scaleMax="' .. x2 .. ' ' .. y2 .. ' ' .. z2 .. '"'
            end
        end

        if not partChange.visibilityMin then
            part = part .. ' visibilityMin="false"'
        end

        if not partChange.visibilityMax then
            part = part .. ' visibilityMax="false"'
        end

        part = part .. '/>\n'

        return part
    end

    return nil
end

function UP_Creator:storeCharacterTargetNodes(filename, seat, seatId)
    if filename ~= nil and seat ~= nil then
        filename = filename:lower()

        if self.vehicles[filename] == nil then
            self.vehicles[filename] = {}
        end

        if self.vehicles[filename][seatId] == nil then
            self.vehicles[filename][seatId] = {targetNodes = {}}
        end

        for targetId, target in pairs (seat.passengerCharacter.ikChainTargets) do
            if self.vehicles[filename][seatId].targetNodes[targetId] == nil then
                local x, y, z = getTranslation(target.targetNode)
                local rx, ry, rz = getRotation(target.targetNode)

                self.vehicles[filename][seatId].targetNodes[targetId] = {
                    trans = string.format("%s %s %s", x, y, z),
                    rot = string.format("%s %s %s", rx, ry, rz)
                }
            end
        end
    end
end

function UP_Creator:getDriverPosition(vehicle, xmlFile, targetTransformId)
    local driverTG = I3DUtil.indexToObject(vehicle.components, getXMLString(xmlFile, "vehicle.enterable.characterNode#node"), vehicle.i3dMappings)

    local position = UP_Creator.getRoundedTrans(driverTG, 3, true, targetTransformId)
    local rotation = UP_Creator.getRoundedRot(driverTG, 3, true, targetTransformId)

    return {position = position, rotation = rotation}
end

function UP_Creator:writeXML(xmlPath, categoryData)
    if self.content ~= nil and type(self.content) == "string" then
        local file = io.open (xmlPath, "w")

        if file ~= nil then
            local content = '<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n\n'

            if self.raycastNodeErrors ~= nil and self.raycastNodeErrors > 0 then
                content = content .. '<!-- IMPORTANT: ( ' ..tostring(self.raycastNodeErrors).. ' ) RaycastNode(s) have a position of "0 0 0" and these should be fixed. -->\n\n'
            end

            if self.isDev and categoryData ~= nil then
                content = content .. categoryData .. '\n\n'
            end

            content = content .. '<universalPassengerVehicles>\n' .. self.content .. '\n</universalPassengerVehicles>'

            file:write(content)
            file:close()
        end
    else
        print("  Error: Failed to create XML, content is missing!")
    end

    self.listActive = false
    self.infoActive = false
end

function UP_Creator:loadVehicleList()
    self.vehicleList = {}
    --self:setupSeats()

    -- Read directly from game folder.
    -- Removed as only needed by GtX :-)
end

function UP_Creator.getRoundedTrans(var, precision, toString, targetTransformId)
    local x, y, z = 0, 0, 0

    precision = precision or 0

    if var ~= nil then
        if targetTransformId == nil then
            x, y, z = getTranslation(var)
        else
            x, y, z = localToLocal(var, targetTransformId, 0, 0, 0)
        end
    end

    if toString == true then
        x = UP_Creator.getValidValue(MathUtil.round(x, precision))
        y = UP_Creator.getValidValue(MathUtil.round(y, precision))
        z = UP_Creator.getValidValue(MathUtil.round(z, precision))

        return string.format("%s %s %s", x, y, z)
    else
        x = UP_Creator.getValidValue(MathUtil.round(x, precision))
        y = UP_Creator.getValidValue(MathUtil.round(y, precision))
        z = UP_Creator.getValidValue(MathUtil.round(z, precision))

        return x, y, z
    end
end

function UP_Creator.getRoundedRot(var, precision, toString, targetTransformId)
    local rx, ry, rz = 0, 0, 0

    precision = precision or 0

    if var ~= nil then
        if targetTransformId == nil then
            rx, ry, rz = getRotation(var)
        else
            rx, ry, rz = localRotationToLocal(var, targetTransformId, 0, 0, 0)
        end
    end

    if toString == true then
        rx = UP_Creator.getValidValue(MathUtil.round(math.deg(rx), precision))
        ry = UP_Creator.getValidValue(MathUtil.round(math.deg(ry), precision))
        rz = UP_Creator.getValidValue(MathUtil.round(math.deg(rz), precision))

        return string.format("%s %s %s", rx, ry, rz)
    else
        rx = UP_Creator.getValidValue(MathUtil.round(math.deg(rx), precision))
        ry = UP_Creator.getValidValue(MathUtil.round(math.deg(ry), precision))
        rz = UP_Creator.getValidValue(MathUtil.round(math.deg(rz), precision))

        return rx, ry, rz
    end
end

function UP_Creator.getRoundedTable(tab, precision, degree, toString)
    local x, y, z = 0, 0, 0

    if tab ~= nil then
        x = tab[1] or x
        y = tab[2] or y
        z = tab[3] or z
    end

    if degree then
        x = UP_Creator.getValidValue(MathUtil.round(math.deg(x), precision))
        y = UP_Creator.getValidValue(MathUtil.round(math.deg(y), precision))
        z = UP_Creator.getValidValue(MathUtil.round(math.deg(z), precision))
    else
        x = UP_Creator.getValidValue(MathUtil.round(x, precision))
        y = UP_Creator.getValidValue(MathUtil.round(y, precision))
        z = UP_Creator.getValidValue(MathUtil.round(z, precision))
    end

    if toString == true then
        return string.format("%s %s %s", x, y, z)
    end

    return x, y, z
end

function UP_Creator.noNilRound(value, precision, default)
    if value ~= nil then
        return MathUtil.round(value, precision)
    end

    return default or 0
end

function UP_Creator.getCorrectedRotation(rot, factor)
    local pi = math.pi

    if rot > pi then
        rot = -pi
    elseif rot < -pi then
        rot = pi
    end

    if rot > pi then
        rot = rot - factor
    else
        rot = rot + factor
    end

    return rot
end

function UP_Creator.getValidValue(value)
    if value == 0 then
        return math.abs(value)
    end

    return value
end
