----------------------------------------------------------------------------
-- @Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
---@v.1.2.0.0---------------------------------------------------------------
----------------------------------------------------------------------------
-- @date Jan1/2019-Feb16/2021-----------------------------------------------
----------------------------------------------------------------------------

realDirtColor = {};
realDirtColor.title = "Real Dirt Color";
realDirtColor.author = "ViperGTS96";
realDirtColor.modDirectory  = g_currentModDirectory;
----------<Initialize New Dirt Colors>----------
realDirtColor.colors = {};
realDirtColor.colors.brownMud = {};
realDirtColor.colors.brownMud.r, realDirtColor.colors.brownMud.g, realDirtColor.colors.brownMud.b = 0.059, 0.038, 0.021;
realDirtColor.colors.mud = realDirtColor.colors.brownMud;
realDirtColor.colors.redMud = {};
realDirtColor.colors.redMud.r, realDirtColor.colors.redMud.g, realDirtColor.colors.redMud.b = 0.34, 0.09, 0.06;
realDirtColor.colors.grass = {};
realDirtColor.colors.grass.r, realDirtColor.colors.grass.g, realDirtColor.colors.grass.b  = 0.035, 0.055, 0.006;
realDirtColor.colors.chaff = {};
realDirtColor.colors.chaff.r, realDirtColor.colors.chaff.g, realDirtColor.colors.chaff.b  = 0.09, 0.1, 0.002;
realDirtColor.colors.lime = {};
realDirtColor.colors.lime.r, realDirtColor.colors.lime.g, realDirtColor.colors.lime.b = 0.82, 0.9, 0.82;
realDirtColor.colors.snow = {};
realDirtColor.colors.snow.r, realDirtColor.colors.snow.g, realDirtColor.colors.snow.b  = 0.83, 0.83, 0.9;
realDirtColor.colors.manure = {};
realDirtColor.colors.manure.r, realDirtColor.colors.manure.g, realDirtColor.colors.manure.b  = 0.176, 0.099, 0.025;
realDirtColor.colors.slurry = {};
realDirtColor.colors.slurry.r, realDirtColor.colors.slurry.g, realDirtColor.colors.slurry.b = 0.059, 0.046, 0.021;
realDirtColor.colors.redDirt = {};
realDirtColor.colors.redDirt.r, realDirtColor.colors.redDirt.g, realDirtColor.colors.redDirt.b  = 0.65, 0.18, 0.1;
----------<Initialize Old Dirt Color>-----------
realDirtColor.colors.brownDirt = {};
realDirtColor.colors.brownDirt.r, realDirtColor.colors.brownDirt.g, realDirtColor.colors.brownDirt.b  = 0.2, 0.14, 0.08 -- [default FS Dirt Color]
realDirtColor.colors.dryDirt = realDirtColor.colors.brownDirt;
------------------------------------------------
--[[         --{NO LONGER USED}--
realDirtColor.bits = {} -- Bits discovered with hours of testing. --1536(PossibleWV) 
realDirtColor.bits.lime = { 6177, 6179, 6625, 6305, 6369, 6433, 6561, 7023, 7201, 7202, 7203, 7267, 7329, 7330, 7331, 7393, 7394, 7395, 7410, 7441, 7457, 7458, 7459, 7585, 7586, 7587, 7650, 7713, 7843, 7849 }
realDirtColor.bits.manure = { 273, 275, 401, 465, 529, 593, 657, 721, 1298, 1299, 1426, 1427, 1490, 1553, 3346, 3538, 3665, 3729, 3730, 3793, 5395, 5521, 5651, 6417, 7442, 7570, 7571, 7634, 7697, 7761, 7825, 7889 }
realDirtColor.bits.slurry = { 281, 283, 409, 473, 520, 537, 572, 601, 665, 729, 737, 1306, 1307, 1435, 1536, 1561, 1754, 3481, 3483, 3547, 3609, 3673, 3737, 3801, 4505, 5529, 6425, 6681, 7450, 7642, 7705, 7769, 7833, 7898 } ]]
------<Excluded from independent mode>----------
realDirtColor.riskyVehicleTypes = { "PLANTERS", "SEEDERS", "WEEDERS", "TEDDERS", "WINDROWERS", "PLOWS", "SUBSOILERS", "CULTIVATORS", "DISCHARROWS", "POWERHARROWS" }
--"SUGARCANEHARVESTING","POTATOHARVESTING","BEETHARVESTING"
realDirtColor.riskyVehicleNames = { "TATRA PHOENIX 6X6 AGRO-TRUCK" };
realDirtColor.forestryTrackNames = { "ECOtrack", "EVObaltic", "EX", "KovaX", "Magnum", "KovaXRight", "KovaXLeft", "EXRight", "EXLeft"};
realDirtColor.finikyVehicleNames = { "JOHN DEERE XUV865M" };
------------------------------------------------	
realDirtColor.speeds = {};  --Lower the value to lower the speed.
realDirtColor.speeds.body = 0.005; --Base Value Multiplier
realDirtColor.speeds.wheels = 0.01; --Base Value Multiplier
realDirtColor.speeds.revert = 10.0; --Dividend [old=5.0]
realDirtColor.speeds.revertMud = 25.0; --Dividend
realDirtColor.speeds.white = 2.5; --Dividend
realDirtColor.speeds.boost = 2.0; --Multiplier
realDirtColor.speeds.megaBoost = 7.5; --Multiplier
-----------<Initialize XML Settings>------------
realDirtColor.simpleMode = false;
realDirtColor.writeToLog = false;
realDirtColor.debugging = false;
realDirtColor.maxWheelLimit = 8;
------------------------------------------------

function realDirtColor.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Washable, specializations)
		and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function realDirtColor.registerEventListeners(vehicleType)
	for _, functionName in pairs( { "onPostLoad", "onUpdate", "saveToXMLFile" } ) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, realDirtColor);
	end;
end;

function realDirtColor:loadSettings()

	local xmLfileName = realDirtColor.modDirectory.."settings.xml"
	local settingsFile = loadXMLFile("realDirtColor_XML", xmLfileName, "realDirtColorSettings");
	local redMapNames = {};
	if settingsFile ~= nil then
		realDirtColor.simpleMode = Utils.getNoNil(getXMLBool(settingsFile, "settings.simpleMode#enabled"), realDirtColor.simpleMode);
		realDirtColor.writeToLog = Utils.getNoNil(getXMLBool(settingsFile, "settings.writeToLog#showVehicles"), realDirtColor.writeToLog);
		realDirtColor.debugging = Utils.getNoNil(getXMLBool(settingsFile, "settings.writeToLog#debugging"), realDirtColor.debugging);
		realDirtColor.maxWheelLimit = Utils.getNoNil(getXMLInt(settingsFile, "settings.independentMode#maxNumOfWheels"), realDirtColor.maxWheelLimit);
		realDirtColor.speeds.body = Utils.getNoNil(getXMLFloat(settingsFile, "settings.colorSettings#baseSpeed"), realDirtColor.speeds.body);
		realDirtColor.speeds.revert = Utils.getNoNil(getXMLFloat(settingsFile, "settings.colorSettings#revertSpeed"), realDirtColor.speeds.revert);
		if realDirtColor.speeds.body > 0.01 then --Limit the amount of adjustment to prevent error.
			realDirtColor.speeds.body = 0.01;
		elseif realDirtColor.speeds.body < 0.0001 then
			realDirtColor.speeds.body = 0.0001;
		end;
		if realDirtColor.speeds.revert > 100.0 then --Limit the amount of adjustment to prevent error.
			realDirtColor.speeds.revert = 100.0;
		elseif realDirtColor.speeds.revert < 1.5 then
			realDirtColor.speeds.revert = 1.5;
		end;
		realDirtColor.speeds.wheels = realDirtColor.speeds.body * 2;
		realDirtColor.speeds.revertMud = realDirtColor.speeds.revert*2.5;
		local i = 0;
		while true do
			local mapName = getXMLString(settingsFile, "settings.redDirtMaps.redDirtMap"..i.."#name");
			if mapName == nil then
				break;
			end;
			redMapNames[i+1] = mapName;
			i = i + 1;
		end;
	else
		print("Warning: Cannot find settings file for '"..realDirtColor.title.."'");
	end;

	return realDirtColor.simpleMode, redMapNames;

end;

function realDirtColor:southernDirt()
	realDirtColor.colors.dryDirt = realDirtColor.colors.redDirt;
	realDirtColor.colors.mud = realDirtColor.colors.redMud;
	print("'Red Dirt/Mud' Enabled for '"..realDirtColor.title.."'");
end;

function realDirtColor:setChildrenDirtColor(parentNode,r,g,b)
	if getNumOfChildren(parentNode) > 0 then
		for i=0, getNumOfChildren(parentNode)-1 do
			local childNode = getChildAt(parentNode, i);
			if getHasClassId(childNode, ClassIds.SHAPE) and getHasShaderParameter(childNode, "dirtColor") then
				setShaderParameter(childNode, "dirtColor", r,g,b, 0, false);
			end;
			realDirtColor:setChildrenDirtColor(childNode,r,g,b);
		end;
	end;
end;
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------PostLoad--------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function realDirtColor:onPostLoad(savegame)

  	self.bodypart = {};

	if self.spec_washable ~= nil then
		for _, washableNodes in pairs(self.spec_washable.washableNodes) do
			for _, node in pairs(washableNodes.nodes) do
				table.insert(self.bodypart,node);
			end;
		end;
	else
		if self.bodypart ~= nil then
			self.bodypart = nil;
		end;
	end;

	if self.bodypart ~= nil and #self.bodypart > 0 then
		local disableRDC = Utils.getNoNil(getXMLBool(self.xmlFile, string.format("vehicle.realDirtColor#disable")), false);
		if disableRDC then
			self.bodypart = nil;
			if realDirtColor.debugging then
				print("'"..realDirtColor.title.."' disabled for "..FSBaseMission:getVehicleName(self));
			end;
			return; --abort script
		end;
		local overrideToSimpleMode = Utils.getNoNil(getXMLBool(self.xmlFile, string.format("vehicle.realDirtColor#useSimpleMode")), false);
		if overrideToSimpleMode then
			self.tooManyWheelsRDC = true;
			overrideToSimpleMode = nil;
		end;
		local ignoreRDCWhlLimit = Utils.getNoNil(getXMLBool(self.xmlFile, string.format("vehicle.realDirtColor#ignoreRDCWheelLimit")), false);
		if not ignoreRDCWhlLimit then
			if self.tooManyWheelsRDC == nil then
				local storeCat = g_storeManager:getItemByXMLFilename(self.configFileName)
				if storeCat ~= nil and storeCat.categoryName ~= nil then
					storeCat = storeCat.categoryName;
					for _, type in pairs(realDirtColor.riskyVehicleTypes) do
						if type == storeCat then
							self.tooManyWheelsRDC = true;
							self.rdcAdjDetector = Utils.getNoNil(self.sizeLength/2, 1.0);
							if realDirtColor.debugging then
								print("'"..realDirtColor.title.."' detected a vehicle in "..storeCat.."; Vehicle/tool set to simple mode.");
							end;
						end;
					end;
				end;
			end;
			if self.tooManyWheelsRDC == nil then
				if self.spec_wheels ~= nil and self.spec_wheels.wheels ~= nil and #self.spec_wheels.wheels > realDirtColor.maxWheelLimit then
					self.tooManyWheelsRDC = true; --Reduce CPU usage by shutting off independent wheel mode on vehicles (huge cultivators)
					if realDirtColor.debugging then
						print("'"..realDirtColor.title.."' detected more than "..realDirtColor.maxWheelLimit.." wheels; Vehicle/tool set to simple mode.");
					end;
				end;
			end;
			if self.tooManyWheelsRDC == nil then
				for _, riskName in pairs(realDirtColor.riskyVehicleNames) do
					if FSBaseMission:getVehicleName(self) == riskName then
						self.tooManyWheelsRDC = true;
						if realDirtColor.debugging then
							print("'"..realDirtColor.title.."' detected "..riskName.."; Vehicle/tool set to simple mode.");
						end;
					end;
				end;
			end;
		end;

		if not realDirtColor.simpleMode and self.tooManyWheelsRDC == nil then
	   ---------------------------------------------------------------------------------------------------------------------------
	   ---------------------Remove Wheel Parts from Body Part Table for Independent Color Control---------------------------------
	   ---------------------------------------------------------------------------------------------------------------------------
			--[[if realDirtColor.debugging then
				print(#self.bodypart);
			end;]]
			-------------Crawlers-----------
			if self.spec_crawlers ~= nil and self.spec_crawlers.crawlers ~= nil then
				for _, crawler in pairs(self.spec_crawlers.crawlers) do
					for i, crawler in pairs(self.spec_crawlers.crawlers) do
						for partIndex, bodypart in pairs(self.bodypart) do
							--crawler = self.spec_crawlers.crawlers[i];
							if crawler.node ~= nil and crawler.node == bodypart then
								table.remove(self.bodypart, partIndex);
								crawler.rDC = true;
							end;
							if crawler.crawler ~= nil and crawler.crawler == bodypart then
								table.remove(self.bodypart, partIndex);
								crawler.rDC = true;
							end;
							if crawler.loadedCrawler ~= nil and crawler.loadedCrawler == bodypart then
								table.remove(self.bodypart, partIndex);
								crawler.rDC = true;
								crawler.crawlerBase = crawler.loadedCrawler;
							end;
							if crawler.scrollerNodes ~= nil then
								for _, scrollerNode in pairs(crawler.scrollerNodes) do
									if scrollerNode.node ~= nil and scrollerNode.node == bodypart then
										table.remove(self.bodypart, partIndex);
										crawler.rDC = true;
										if crawler.crawlerBase == nil then
											local scrollerParent = getParent(scrollerNode.node);
											local ii = 0;
											for i, trackName in pairs(realDirtColor.forestryTrackNames) do
												--print(getName(scrollerParent).." : "..trackName.." : "..tostring(i));
												if getName(scrollerParent) ~= trackName then
													ii = ii + 1;
												end;
												if (ii >= #realDirtColor.forestryTrackNames) then
													crawler.crawlerBase = scrollerParent;
													--[[if realDirtColor.debugging then
														print("regular track")
													end;]]
												elseif (i >= #realDirtColor.forestryTrackNames) then
													crawler.crawlerBase = bodypart;
													--[[if realDirtColor.debugging then
														print("forestry track")
													end;]]
												end;
											end;
										end;
									end;
								end;
							end;
							if crawler.additionalCrawlers ~= nil and #crawler.additionalCrawlers > 0 then
								for _, additionalWheel in pairs(crawler.additionalCrawlers) do
									if additionalCrawler.node ~= nil and additionalCrawler.node == bodypart then
										table.remove(self.bodypart, partIndex);
									end;
									if additionalCrawler.loadedCrawler ~= nil and additionalCrawler.loadedCrawler == bodypart then
										table.remove(self.bodypart, partIndex);
										additionalCrawler.crawlerBase = additionalCrawler.loadedCrawler;
									end;
									if additionalCrawler.rotatingParts ~= nil then
										for _, rotationPart in pairs(additionalCrawler.rotatingParts) do
											if rotationPart.node ~= nil then
												if getHasClassId(rotationPart.node, ClassIds.SHAPE) and rotationPart.node == bodypart then
												table.remove(self.bodypart, partIndex);
												elseif getNumOfChildren(rotationPart.node) > 0 then
													for i=0, getNumOfChildren(rotationPart.node)-1 do
														local rotatorChild = getChildAt(rotationPart.node, i);
														if getHasClassId(rotatorChild, ClassIds.SHAPE) and rotatorChild == bodypart then
															table.remove(self.bodypart, partIndex);
														end;
													end;
												end;
											end;
										end;
									end;
									if additionalCrawler.scrollerNodes ~= nil then
										for _, scrollerNode in pairs(additionalCrawler.scrollerNodes) do
											if scrollerNode.node ~= nil and scrollerNode.node == bodypart then
												table.remove(self.bodypart, partIndex);
												if additionalCrawler.crawlerBase == nil then
													local scrollerParent = getParent(scrollerNode.node);
													local ii = 0;
													for i, trackName in pairs(realDirtColor.forestryTrackNames) do
														--print(getName(scrollerParent).." : "..trackName.." : "..tostring(i));
														if getName(scrollerParent) ~= trackName then
															ii = ii + 1;
														end;
														if (ii >= #realDirtColor.forestryTrackNames) then
															additionalCrawler.crawlerBase = scrollerParent;
															--[[if realDirtColor.debugging then
																print("additional regular track")
															end;]]
														elseif (i >= #realDirtColor.forestryTrackNames) then
															additionalCrawler.crawlerBase = bodypart;
															--[[if realDirtColor.debugging then
																print("additional forestry track")
															end;]]
														end;
													end;
												end;
											end;
										end;
									end;
								end;
							end;
						end;
					end;
				end;
				--[[if realDirtColor.debugging then
					print(#self.bodypart);
				end;]]
			end;
			-------------Wheels-----------
			if self.spec_wheels ~= nil and self.spec_wheels.wheels ~= nil then
				for _, wheel in pairs(self.spec_wheels.wheels) do
					local wheelNodes = I3DUtil.getNodesByShaderParam(wheel.repr, "dirtColor", wheel)
					for _, wheelNode in pairs(wheelNodes) do 
						for partIndex, bodypart in pairs(self.bodypart) do
							local skipPart = false;
							for _, component in pairs(self.components) do
								if bodypart == component.node then skipPart = true; end;
							end;
							if bodypart == wheelNode and not skipPart then
								table.remove(self.bodypart, partIndex);
								--[[if realDirtColor.debugging then
									print("removed wheel.repr part : "..getName(bodypart).." / "..getName(wheelNode));
								end;]]
								wheel.rDC = true;
								break;
							end;
						end;
					end;
					if wheel.repr ~= wheel.driveNode then
						local wheelNodes = I3DUtil.getNodesByShaderParam(wheel.driveNode, "dirtColor", wheel)
						for _, wheelNode in pairs(wheelNodes) do 
							for partIndex, bodypart in pairs(self.bodypart) do
								local skipPart = false;
								for _, component in pairs(self.components) do
									if bodypart == component.node then skipPart = true; end;
								end;
								if bodypart == wheelNode and not skipPart then
									table.remove(self.bodypart, partIndex);
									--[[if realDirtColor.debugging then
										print("removed wheel.driveNode part : "..getName(bodypart).." / "..getName(wheelNode));
									end;]]
									wheel.rDC = true;
									break;
								end;
							end;
						end;
					end;
				end;
				--[[if realDirtColor.debugging then
					print(#self.bodypart);
				end;]]
			end;
			--[[if self.spec_wheels ~= nil and self.spec_wheels.hubs ~= nil then
				for i, hub in pairs (self.spec_wheels.hubs) do
					local wheel = self.spec_wheels.wheels[i];
					if wheel ~= nil and wheel["wheelTire"] ~= nil then
						for partIndex, bodypart in pairs(self.bodypart) do
							if hub.node == bodypart then
								table.remove(self.bodypart, partIndex);
							end;
						end;
					end;
				end;
			end;]]
		end;
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------Initialize Colors to Components---------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		--<<:COLORKEY:>>  0.1 = Dirt, 0.5/0.55 = Mud, 1 = Grass, 1.5 = Chaff, 2 = Snow, 3 = Lime, 4 = Manure, 5 = Slurry/Digestate
		self.previousDirtColor = 0.1; 
		self.currentDirtColor = 0.0; 
		self.newDirtColor = 0.1;
		-------------------------------------------------------------------------------------	
		
		self.rdWidth = Utils.getNoNil(self.sizeWidth, 0);
		self.rdLength = Utils.getNoNil(self.sizeLength, 0);

		if self.rdWidth <= 0 then
			self.rdWidth = 2;
		else
			self.rdWidth = self.rdWidth - (self.rdWidth * 0.75) --Minus wheels
		end;
		if self.rdLength <= 0 then
			self.rdLength = 2;
		else
			self.rdLength = self.rdLength - (self.rdLength * 0.85) -- Minus Front and rear links/weights
		end;

		self.targetRDColor = {};
		self.targetRDColor.r, self.targetRDColor.g, self.targetRDColor.b = realDirtColor.colors.dryDirt.r, realDirtColor.colors.dryDirt.g, realDirtColor.colors.dryDirt.b;

		if self.targetRDColor.r == realDirtColor.colors.brownDirt.r then
			self.dryDirtColor = 0;--to detect brown dirt terrain
		else
			self.dryDirtColor = 1;--to detect red dirt terrain
		end;
		
		if not realDirtColor.simpleMode and self.tooManyWheelsRDC == nil then
			if self.spec_wheels ~= nil and self.spec_wheels.wheels ~= nil and #self.spec_wheels.wheels ~= 0 then
				for i, wheel in pairs(self.spec_wheels.wheels) do
					wheel = self.spec_wheels.wheels[i];
					if wheel.rDC ~= nil and wheel.rDC then
						wheel.previousDirtColor = 0.1;
						wheel.currentDirtColor = 0.0;
						wheel.newDirtColor = 0.1;
						wheel.targetRDColor = {};
						wheel.targetRDColor.r, wheel.targetRDColor.g, wheel.targetRDColor.b = self.targetRDColor.r, self.targetRDColor.g, self.targetRDColor.b;
					end;
				end;
			end;

			if self.spec_crawlers ~= nil and self.spec_crawlers.crawlers ~= nil and #self.spec_crawlers.crawlers ~= 0 then
				for i, crawler in pairs(self.spec_crawlers.crawlers) do
					crawler = self.spec_crawlers.crawlers[i];
					if crawler.rDC ~= nil and crawler.rDC then
						crawler.previousDirtColor = 0.1;
						crawler.currentDirtColor = 0.0;
						crawler.newDirtColor = 0.1;
						crawler.targetRDColor = {};
						crawler.targetRDColor.r, crawler.targetRDColor.g, crawler.targetRDColor.b = self.targetRDColor.r, self.targetRDColor.g, self.targetRDColor.b;
					end;
				end;
			end;
		end;
		
		if realDirtColor.writeToLog then
			print("Load mod: '"..realDirtColor.title.."' successfully applied to "..FSBaseMission:getVehicleName(self));--self.typeName
		end;

	end;

------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------Load Save Game Stats-----------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    if savegame ~= nil then
		local colorR = getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.body#r"));
		local colorG = getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.body#g"));
		local colorB = getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.body#b"));
		local savedDirtColor = Utils.getNoNil(getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.body#curIndex")), 0);
		local savedPrevDirtColor = Utils.getNoNil(getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.body#prevIndex")), 0);
		if (colorR ~= nil and colorG ~= nil and colorB ~= nil) then
			self.previousDirtColor = savedPrevDirtColor;
			self.currentDirtColor = savedDirtColor;
			self.newDirtColor = savedDirtColor;
			self.targetRDColor.r, self.targetRDColor.g, self.targetRDColor.b = colorR, colorG, colorB;

			for _, part in pairs(self.bodypart) do
				setShaderParameter(part, "dirtColor", colorR, colorG, colorB, 0, false);
			end;
			
			if not realDirtColor.simpleMode and self.tooManyWheelsRDC == nil then

				if self.spec_wheels ~= nil and self.spec_wheels.wheels ~= nil and #self.spec_wheels.wheels ~= 0 then
					for i, wheel in pairs(self.spec_wheels.wheels) do
						if wheel.rDC ~= nil and wheel.rDC then
					
							local wColorR = getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.wheel"..i.."#r"));
							local wColorG = getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.wheel"..i.."#g"));
							local wColorB = getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.wheel"..i.."#b"));
							local wCurDirtColor = Utils.getNoNil(getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.wheel"..i.."#curIndex")), 0);
							local wPrevDirtColor = Utils.getNoNil(getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.wheel"..i.."#prevIndex")), wCurDirtColor);

							if (wColorR ~= nil and wColorG ~= nil and wColorB ~= nil) then
								colorR, colorG, colorB = wColorR, wColorG, wColorB;
								wheel.previousDirtColor = wPrevDirtColor;
								wheel.currentDirtColor = wCurDirtColor;
								wheel.newDirtColor = wCurDirtColor;
							end;

							wheel.targetRDColor.r, wheel.targetRDColor.g, wheel.targetRDColor.b = colorR, colorG, colorB;

							if wheel["wheelTire"] ~= nil and getHasShaderParameter(wheel["wheelTire"], "dirtColor") then
								setShaderParameter(wheel["wheelTire"], "dirtColor", colorR, colorG, colorB, 0, false);
								realDirtColor:setChildrenDirtColor(wheel["wheelTire"], colorR, colorG, colorB);
							end;
							--[[if wheel.hub ~= nil and wheel.hub.node ~= nil and getHasShaderParameter(wheel.hub.node, "dirtColor") then
								setShaderParameter(wheel.hub.node, "dirtColor", colorR, colorG, colorB, 0, false);
								realDirtColor:setChildrenDirtColor(additionalWheel["wheel.hub.node"], colorR, colorG, colorB);
							end;]]
							if wheel["wheelOuterRim"] ~= nil and getHasShaderParameter(wheel["wheelOuterRim"], "dirtColor") then
								setShaderParameter(wheel["wheelOuterRim"], "dirtColor", colorR, colorG, colorB, 0, false);
								realDirtColor:setChildrenDirtColor(wheel["wheelOuterRim"], colorR, colorG, colorB);
							end;
							if wheel["wheelInnerRim"] ~= nil and getHasShaderParameter(wheel["wheelInnerRim"], "dirtColor") then
								setShaderParameter(wheel["wheelInnerRim"], "dirtColor", colorR, colorG, colorB, 0, false);
								realDirtColor:setChildrenDirtColor(wheel["wheelInnerRim"], colorR, colorG, colorB);
								--[[if getNumOfChildren(wheel["wheelInnerRim"]) > 0 then
									for i=0, getNumOfChildren(wheel["wheelInnerRim"])-1 do
										local wheelInnerRimChild = getChildAt(wheel["wheelInnerRim"], i);
										if getHasClassId(wheelInnerRimChild, ClassIds.SHAPE) and getHasShaderParameter(wheelInnerRimChild, "dirtColor") then
										setShaderParameter(wheelInnerRimChild, "dirtColor", colorR, colorG, colorB, 0, false);
										end;
									end;
								end;]]
							end;
							if wheel["wheelAdditional"] ~= nil and getHasShaderParameter(wheel["wheelAdditional"], "dirtColor") then
								setShaderParameter(wheel["wheelAdditional"], "dirtColor", colorR, colorG, colorB, 0, false);
								realDirtColor:setChildrenDirtColor(wheel["wheelAdditional"], colorR, colorG, colorB);
							end;
							if wheel.bodypart ~= nil then
								for _, part in pairs(wheel.bodypart) do
									setShaderParameter(part, "dirtColor", colorR, colorG, colorB, 0, false);
								end;
							end;
							if wheel.additionalWheels ~= nil and #wheel.additionalWheels > 0 then
								for _, additionalWheel in pairs(wheel.additionalWheels) do	
									if additionalWheel["wheelTire"] ~= nil and getHasShaderParameter(additionalWheel["wheelTire"], "dirtColor") then
										setShaderParameter(additionalWheel["wheelTire"], "dirtColor", colorR, colorG, colorB, 0, false);
										realDirtColor:setChildrenDirtColor(additionalWheel["wheelTire"], colorR, colorG, colorB);
									end;
									if additionalWheel.connector ~= nil and getHasShaderParameter(additionalWheel.connector.node, "dirtColor") then
										setShaderParameter(additionalWheel.connector.node, "dirtColor", colorR, colorG, colorB, 0, false);
										realDirtColor:setChildrenDirtColor(additionalWheel.connector.node, colorR, colorG, colorB);
									end;
									if additionalWheel.hub ~= nil and getHasShaderParameter(additionalWheel.hub.node, "dirtColor") then
										setShaderParameter(additionalWheel.hub.node, "dirtColor", colorR, colorG, colorB, 0, false);
										realDirtColor:setChildrenDirtColor(additionalWheel.hub.node, colorR, colorG, colorB);
									end;
									if additionalWheel.wheelOuterRim ~= nil and getHasShaderParameter(additionalWheel.wheelOuterRim, "dirtColor") then
										setShaderParameter(additionalWheel.wheelOuterRim, "dirtColor", colorR, colorG, colorB, 0, false);
										realDirtColor:setChildrenDirtColor(additionalWheel.wheelOuterRim, colorR, colorG, colorB);
									end;
									if additionalWheel.wheelInnerRim ~= nil and getHasShaderParameter(additionalWheel.wheelInnerRim, "dirtColor") then
										setShaderParameter(additionalWheel.wheelInnerRim, "dirtColor", colorR, colorG, colorB, 0, false);
										realDirtColor:setChildrenDirtColor(additionalWheel.wheelInnerRim, colorR, colorG, colorB);
										--[[if getNumOfChildren(additionalWheel.wheelInnerRim) > 0 then
											for i=0, getNumOfChildren(additionalWheel.wheelInnerRim)-1 do
												local wheelInnerRimChild = getChildAt(additionalWheel.wheelInnerRim, i);
												if getHasClassId(wheelInnerRimChild, ClassIds.SHAPE) and getHasShaderParameter(wheelInnerRimChild, "dirtColor") then
													setShaderParameter(wheelInnerRimChild, "dirtColor", colorR, colorG, colorB, 0, false);
												end;
											end;
										end;]]
									end;
									if additionalWheel["wheelAdditional"] ~= nil and getHasShaderParameter(additionalWheel["wheelAdditional"], "dirtColor") then
										setShaderParameter(additionalWheel["wheelAdditional"], "dirtColor", colorR, colorG, colorB, 0, false);
										realDirtColor:setChildrenDirtColor(additionalWheel["wheelAdditional"], colorR, colorG, colorB);
									end;
								end;
							end;
						end;
					end;
				end;
				if self.spec_wheels ~= nil and self.spec_wheels.hubs ~= nil then
					for _, hub in pairs (self.spec_wheels.hubs) do
						if getHasShaderParameter(hub.node, "dirtColor") then
							setShaderParameter(hub.node, "dirtColor", colorR, colorG, colorB, 0, false);
						end;
					end;
				end;
				if self.spec_crawlers ~= nil and self.spec_crawlers.crawlers ~= nil and #self.spec_crawlers.crawlers ~= 0 then
					for i, crawler in pairs(self.spec_crawlers.crawlers) do
						if crawler.rDC ~= nil and crawler.rDC then

							local cwColorR = getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.crawler"..i.."#r"));
							local cwColorG = getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.crawler"..i.."#g"));
							local cwColorB = getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.crawler"..i.."#b"));
							local cwCurDirtColor = Utils.getNoNil(getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.crawler"..i.."#curIndex")), 0);
							local cwPrevDirtColor = Utils.getNoNil(getXMLFloat(savegame.xmlFile, savegame.key .. string.format(".realDirtColor.crawler"..i.."#prevIndex")), cwCurDirtColor);

							if (cwColorR ~= nil and cwColorG ~= nil and cwColorB ~= nil) then
								colorR, colorG, colorB = cwColorR, cwColorG, cwColorB;
								crawler.previousDirtColor = cwPrevDirtColor;
								crawler.currentDirtColor = cwCurDirtColor;
								crawler.newDirtColor = cwCurDirtColor;
							end;

							crawler.targetRDColor.r, crawler.targetRDColor.g, crawler.targetRDColor.b = colorR, colorG, colorB;

							if crawler.node ~= nil and getHasShaderParameter(crawler.node, "dirtColor") then
								setShaderParameter(crawler.node, "dirtColor", colorR, colorG, colorB, 0, false);
							end;
							if crawler.crawlerBase ~= nil and getHasShaderParameter(crawler.crawlerBase, "dirtColor") then
								setShaderParameter(crawler.crawlerBase, "dirtColor", colorR, colorG, colorB, 0, false);
							end;
							if crawler.shaderParameterComponent ~= nil and getHasShaderParameter(crawler.shaderParameterComponent, "dirtColor") then
								setShaderParameter(crawler.shaderParameterComponent, "dirtColor", colorR, colorG, colorB, 0, false);
							end;
							if crawler.scrollerNodes ~= nil then
								for _, scrollerNode in pairs(crawler.scrollerNodes) do
									if scrollerNode.node ~= nil and getHasShaderParameter(scrollerNode.node, "dirtColor") then
										setShaderParameter(scrollerNode.node, "dirtColor", colorR, colorG, colorB, 0, false);
									end;
								end;
							end;
							if crawler.rotatingParts ~= nil then
								for _, rotationPart in pairs(crawler.rotatingParts) do
									if rotationPart.node ~= nil then
										if getHasClassId(rotationPart.node, ClassIds.SHAPE) and getHasShaderParameter(rotationPart.node, "dirtColor") then
											setShaderParameter(rotationPart.node, "dirtColor", colorR, colorG, colorB, 0, false);
										end;
										realDirtColor:setChildrenDirtColor(rotationPart.node, colorR, colorG, colorB);
										--[[if getNumOfChildren(rotationPart.node) > 0 then
											for i=0, getNumOfChildren(rotationPart.node)-1 do
												local rotatorChild = getChildAt(rotationPart.node, i);
												if getHasClassId(rotatorChild, ClassIds.SHAPE) and getHasShaderParameter(rotatorChild, "dirtColor") then
													setShaderParameter(rotatorChild, "dirtColor", colorR, colorG, colorB, 0, false);
												end;
											end;
										end;]]
									end;
								end;
							end;
							if crawler.additionalCrawlers ~= nil and #wheel.additionalCrawlers > 0 then
								for _, additionalWheel in pairs(wheel.additionalCrawlers) do	
									if additionalCrawler.node ~= nil and getHasShaderParameter(additionalCrawler.node, "dirtColor") then
										setShaderParameter(additionalCrawler.node, "dirtColor", colorR, colorG, colorB, 0, false);
									end;
									if additionalCrawler.crawlerBase ~= nil and getHasShaderParameter(additionalCrawler.crawlerBase, "dirtColor") then
										setShaderParameter(additionalCrawler.crawlerBase, "dirtColor", colorR, colorG, colorB, 0, false);
									end;
									if additionalCrawler.shaderParameterComponent ~= nil and getHasShaderParameter(additionalCrawler.shaderParameterComponent, "dirtColor") then
										setShaderParameter(additionalCrawler.shaderParameterComponent, "dirtColor", colorR, colorG, colorB, 0, false);
									end;
									if additionalCrawler.scrollerNodes ~= nil then
										for _, scrollerNode in pairs(additionalCrawler.scrollerNodes) do
											if scrollerNode.node ~= nil and getHasShaderParameter(scrollerNode.node, "dirtColor") then
												setShaderParameter(scrollerNode.node, "dirtColor", colorR, colorG, colorB, 0, false);
											end;
										end;
									end;
									if additionalCrawler.rotatingParts ~= nil then
										for _, rotationPart in pairs(additionalCrawler.rotatingParts) do
											if rotationPart.node ~= nil then
												if getHasClassId(rotationPart.node, ClassIds.SHAPE) and getHasShaderParameter(rotationPart.node, "dirtColor") then
													setShaderParameter(rotationPart.node, "dirtColor", colorR, colorG, colorB, 0, false);
												end;
												realDirtColor:setChildrenDirtColor(rotationPart.node, colorR, colorG, colorB);
												--[[if getNumOfChildren(rotationPart.node) > 0 then
													for i=0, getNumOfChildren(rotationPart.node)-1 do
														local rotatorChild = getChildAt(rotationPart.node, i);
														if getHasClassId(rotatorChild, ClassIds.SHAPE) and getHasShaderParameter(rotatorChild, "dirtColor") then
															setShaderParameter(rotatorChild, "dirtColor", colorR, colorG, colorB, 0, false);
														end;
													end;
												end;]]
											end;
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		end;
    end;
end;

------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------Save Current Dirt Color-------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function realDirtColor:saveToXMLFile(xmlFile, key)

	if self.bodypart ~= nil and #self.bodypart > 0 then
		local colorRed, colorGreen, colorBlue, _ = getShaderParameter(self.bodypart[1], "dirtColor");	
		if colorRed ~= nil and colorBlue ~= nil and colorGreen ~= nil then
			setXMLFloat(xmlFile, key..".body#r", colorRed)
			setXMLFloat(xmlFile, key..".body#g", colorGreen)
			setXMLFloat(xmlFile, key..".body#b", colorBlue)
			setXMLInt(xmlFile,  key..".body#curIndex", self.newDirtColor)
			setXMLInt(xmlFile,  key..".body#prevIndex", self.previousDirtColor)
		end;

		if self.spec_wheels ~= nil and self.spec_wheels.wheels ~= nil and #self.spec_wheels.wheels ~= 0 then
			for i, wheel in pairs(self.spec_wheels.wheels) do
				wheel = self.spec_wheels.wheels[i];
				if wheel.rDC ~= nil and wheel.rDC and wheel["wheelTire"] ~= nil and getHasShaderParameter(wheel["wheelTire"], "dirtColor") then
					local wheelColorRed, wheelColorGreen, wheelColorBlue, _  = getShaderParameter(wheel["wheelTire"], "dirtColor");	
					setXMLFloat(xmlFile, key..".wheel"..i.."#r", wheelColorRed)
					setXMLFloat(xmlFile, key..".wheel"..i.."#g", wheelColorGreen)
					setXMLFloat(xmlFile, key..".wheel"..i.."#b", wheelColorBlue)
					setXMLInt(xmlFile,  key..".wheel"..i.."#curIndex", wheel.newDirtColor)
					setXMLInt(xmlFile,  key..".wheel"..i.."#prevIndex", wheel.previousDirtColor)
				end;
			end;
		end;

		if self.spec_crawlers ~= nil and self.spec_crawlers.crawlers ~= nil and #self.spec_crawlers.crawlers ~= 0 then
			for i, crawler in pairs(self.spec_crawlers.crawlers) do
				crawler = self.spec_crawlers.crawlers[i];
				if crawler.rDC ~= nil and crawler.rDC and crawler.crawlerBase ~= nil and getHasShaderParameter(crawler.crawlerBase, "dirtColor") then
					local crawlerColorRed, crawlerColorGreen, crawlerColorBlue, _  = getShaderParameter(crawler.crawlerBase, "dirtColor");	
					setXMLFloat(xmlFile, key..".crawler"..i.."#r", crawlerColorRed)
					setXMLFloat(xmlFile, key..".crawler"..i.."#g", crawlerColorGreen)
					setXMLFloat(xmlFile, key..".crawler"..i.."#b", crawlerColorBlue)
					setXMLInt(xmlFile,  key..".crawler"..i.."#curIndex", crawler.newDirtColor)
					setXMLInt(xmlFile,  key..".crawler"..i.."#prevIndex", crawler.previousDirtColor)
				end;
			end;
		end;
	end;

end;

------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------Update Dirt Colors----------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function realDirtColor:onUpdate(dt)

	if self:getLastSpeed() >= 0.1 then
		if self.bodypart ~= nil and #self.bodypart > 0 then
			local zAdjust = 0;
			if self.rdcAdjDetector ~= nil then
				zAdjust = self.rdcAdjDetector;
			end;
			local x,y,z = getWorldTranslation(self.components[1].node);
			local y0 = Utils.getNoNil(getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode,x,y,z),y);
			local x0,_,z0 = localToWorld(self.components[1].node, self.rdWidth, 0, zAdjust);
			local x1,_,z1 = localToWorld(self.components[1].node, -self.rdWidth, 0, zAdjust);
			if zAdjust ~= 0 then
				y0 = Utils.getNoNil(getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode,x,y,z0),y0);
			end;
			local curDirtCol = {}
			curDirtCol.r, curDirtCol.g, curDirtCol.b, _  = getShaderParameter(self.bodypart[1], "dirtColor");

			local function getIsInWater(y)
				local waterY = g_currentMission.waterY;
				if g_currentMission.waterBodyFX ~= nil then waterY = g_currentMission.waterBodyFX.waterY; end;
				if waterY ~= nil and y < waterY then return true; end;
				return false;
			end;
			local rainScale = g_currentMission.environment.weather:getRainFallScale()
			local timeSinceLastRain = g_currentMission.environment.weather:getTimeSinceLastRain()
			local rainWeather = false;
			local wetGround = (g_currentMission.environment.groundWetness >= 0.01) or getIsInWater(y0);
			local colorSpeed = realDirtColor.speeds.body;
		----------------------------------RAIN/WET GROUND DETECTION-----------------------------------
			if not (rainScale <= 0.1 and timeSinceLastRain > 20) then
				rainWeather = true;
			end;
			if (wetGround or rainWeather) and (self.newDirtColor == 0.1 or self.currentDirtColor == 0.1) then -- Change Dirt color to "Mud color" depending on ground moisture level.
				self.newDirtColor = 0.5;
				--colorSpeed = colorSpeed * realDirtColor.speeds.boost; --Dirt to Mud Speed Boost.
				--if realDirtColor.debugging then
				--	print("mud color enabled")
				--end;
			elseif (not wetGround and not rainWeather) and (self.newDirtColor == 0.5 or self.currentDirtColor == 0.5) then -- Change Dirt color back to "Dry Dirt" color.
				self.newDirtColor = 0.1;
				--if realDirtColor.debugging then
				--	print("mud color disabled")
				--end;
			end;
		------------------------------------------------------------------------------------------------------------------------------------------------
		---------------------------------------------------------------BodyParts------------------------------------------------------------------------
		------------------------------------------------------------------------------------------------------------------------------------------------
			self.previousDirtColor, self.currentDirtColor, self.targetRDColor = realDirtColor:getNewColor(self.previousDirtColor, self.currentDirtColor, self.newDirtColor, self.targetRDColor);

			colorSpeed = realDirtColor:adjustColorSpeed(self.currentDirtColor, self.previousDirtColor, colorSpeed);

			if (curDirtCol.r ~= self.targetRDColor.r) and (curDirtCol.g ~= self.targetRDColor.g) and (curDirtCol.b ~= self.targetRDColor.b) then

				if self.newDirtColor > 0.0 then
					curDirtCol.r, curDirtCol.g, curDirtCol.b = realDirtColor:colorChangeFormula(curDirtCol, self.targetRDColor, dt, colorSpeed);
				end;

				for partIndex, part in pairs(self.bodypart) do
					if part ~= nil then
						setShaderParameter(part, "dirtColor", curDirtCol.r, curDirtCol.g, curDirtCol.b, 0, false);
					else
						table.remove(self.bodypart, partIndex);
					end;
				end;
				
			end;

			if not realDirtColor.simpleMode and self.tooManyWheelsRDC == nil then
			------------------------------------------------------------------------------------------------------------------------------------------------
			-----------------------------------------------------------------WHEELS-------------------------------------------------------------------------
			------------------------------------------------------------------------------------------------------------------------------------------------	
				if self.spec_wheels ~= nil and self.spec_wheels.wheels ~= nil and #self.spec_wheels.wheels ~= 0 then
					for i, wheel in pairs(self.spec_wheels.wheels) do
						wheel = self.spec_wheels.wheels[i];
						if wheel.rDC ~= nil and wheel.rDC then
							local wheelCurDirtCol = {};
							if wheel["wheelTire"] ~= nil and getHasShaderParameter(wheel["wheelTire"], "dirtColor") then
								wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, _  = getShaderParameter(wheel["wheelTire"], "dirtColor");	

								if wheelCurDirtCol.r <= 0.0 then									
									wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b = realDirtColor:findWheelDirtColor(wheel);
								end;

								if realDirtColor.debugging then
									if Input.isKeyPressed(Input.KEY_lctrl) and Input.isKeyPressed(Input.KEY_1) then
										print(" r:"..wheelCurDirtCol.r.." g:"..wheelCurDirtCol.g.." b:"..wheelCurDirtCol.b);
									end;
								end;

								local wheelColorSpeed = realDirtColor.speeds.wheels;

								if (wetGround or rainWeather) and (wheel.newDirtColor == 0.1 or wheel.currentDirtColor == 0.1) then -- Change Dirt color to "Mud color" depending on ground moisture level.
									wheel.newDirtColor = 0.5;
									wheelColorSpeed = wheelColorSpeed * realDirtColor.speeds.boost; --Dirt to Mud Speed Boost.
								elseif (not wetGround and not rainWeather) and (wheel.newDirtColor == 0.5 or wheel.currentDirtColor == 0.5) then -- Change Dirt color back to "Dry Dirt" color.
									wheel.newDirtColor = 0.1;
								end;
								
								wheel.previousDirtColor, wheel.currentDirtColor, wheel.targetRDColor = realDirtColor:getNewColor(wheel.previousDirtColor, wheel.currentDirtColor, wheel.newDirtColor, wheel.targetRDColor);
								
								wheelColorSpeed = realDirtColor:adjustColorSpeed(wheel.currentDirtColor, wheel.previousDirtColor, wheelColorSpeed);

								if (wheelCurDirtCol.r ~= wheel.targetRDColor.r) and (wheelCurDirtCol.g ~= wheel.targetRDColor.g) and (wheelCurDirtCol.b ~= wheel.targetRDColor.b) then

									if wheel.newDirtColor > 0.0 then
										wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b = realDirtColor:colorChangeFormula(wheelCurDirtCol, wheel.targetRDColor, dt, wheelColorSpeed);
									end;

									if wheel.lastColor ~= nil and wheel.onRoadSurface == nil then -- Update old Color information and (Bonus) Sets Driving PS Color
										wheel.lastColor = {wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0};
									end;

									if wheel["wheelTire"] ~= nil and getHasShaderParameter(wheel["wheelTire"], "dirtColor") then
										setShaderParameter(wheel["wheelTire"], "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
										realDirtColor:setChildrenDirtColor(wheel["wheelTire"], wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b);
									end;
									--[[if wheel.hub ~= nil and wheel.hub.node ~= nil and getHasShaderParameter(wheel.hub.node, "dirtColor") then
										setShaderParameter(wheel.hub.node, "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
										realDirtColor:setChildrenDirtColor(wheel.hub.node, wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b);
									end;]]
									if wheel["wheelOuterRim"] ~= nil and getHasShaderParameter(wheel["wheelOuterRim"], "dirtColor") then
										setShaderParameter(wheel["wheelOuterRim"], "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
										realDirtColor:setChildrenDirtColor(wheel["wheelOuterRim"], wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b);
									end;
									if wheel["wheelInnerRim"] ~= nil and getHasShaderParameter(wheel["wheelInnerRim"], "dirtColor") then
										setShaderParameter(wheel["wheelInnerRim"], "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
										realDirtColor:setChildrenDirtColor(wheel["wheelInnerRim"], wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b);
										--[[if getNumOfChildren(wheel["wheelInnerRim"]) > 0 then
											for i=0, getNumOfChildren(wheel["wheelInnerRim"])-1 do
												local wheelInnerRimChild = getChildAt(wheel["wheelInnerRim"], i);
												if getHasClassId(wheelInnerRimChild, ClassIds.SHAPE) and getHasShaderParameter(wheelInnerRimChild, "dirtColor") then
												setShaderParameter(wheelInnerRimChild, "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
												end;
											end;
										end;]]
									end;
									if wheel["wheelAdditional"] ~= nil and getHasShaderParameter(wheel["wheelAdditional"], "dirtColor") then
										setShaderParameter(wheel["wheelAdditional"], "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
										realDirtColor:setChildrenDirtColor(wheel["wheelAdditional"], wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b);
									end;
									if wheel.bodypart ~= nil then
										for _, part in pairs(wheel.bodypart) do
											setShaderParameter(part, "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
										end;
									end;
									if wheel.additionalWheels ~= nil and #wheel.additionalWheels > 0 then
										for _, additionalWheel in pairs(wheel.additionalWheels) do	
											if additionalWheel["wheelTire"] ~= nil and getHasShaderParameter(additionalWheel["wheelTire"], "dirtColor") then
												setShaderParameter(additionalWheel["wheelTire"], "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
												realDirtColor:setChildrenDirtColor(additionalWheel["wheelTire"], wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b);
											end;
											if additionalWheel.connector ~= nil and getHasShaderParameter(additionalWheel.connector.node, "dirtColor") then
												setShaderParameter(additionalWheel.connector.node, "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
												realDirtColor:setChildrenDirtColor(additionalWheel.connector.node, wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b);
											end;
											if additionalWheel.hub ~= nil and getHasShaderParameter(additionalWheel.hub.node, "dirtColor") then
												setShaderParameter(additionalWheel.hub.node, "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
												realDirtColor:setChildrenDirtColor(additionalWheel.hub.node, wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b);
											end;
											if additionalWheel.wheelOuterRim ~= nil and getHasShaderParameter(additionalWheel.wheelOuterRim, "dirtColor") then
												setShaderParameter(additionalWheel.wheelOuterRim, "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
												realDirtColor:setChildrenDirtColor(additionalWheel.wheelOuterRim, wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b);
											end;
											if additionalWheel.wheelInnerRim ~= nil and getHasShaderParameter(additionalWheel.wheelInnerRim, "dirtColor") then
												setShaderParameter(additionalWheel.wheelInnerRim, "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
												realDirtColor:setChildrenDirtColor(additionalWheel.wheelInnerRim, wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b);
												--[[if getNumOfChildren(additionalWheel.wheelInnerRim) > 0 then
													for i=0, getNumOfChildren(additionalWheel.wheelInnerRim)-1 do
														local wheelInnerRimChild = getChildAt(additionalWheel.wheelInnerRim, i);
														if getHasClassId(wheelInnerRimChild, ClassIds.SHAPE) and getHasShaderParameter(wheelInnerRimChild, "dirtColor") then
															setShaderParameter(wheelInnerRimChild, "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
														end;
													end;
												end;]]
											end;
											if additionalWheel["wheelAdditional"] ~= nil and getHasShaderParameter(additionalWheel["wheelAdditional"], "dirtColor") then
												setShaderParameter(additionalWheel["wheelAdditional"], "dirtColor", wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b, 0, false);
												realDirtColor:setChildrenDirtColor(additionalWheel["wheelAdditional"], wheelCurDirtCol.r, wheelCurDirtCol.g, wheelCurDirtCol.b);
											end;
										end;
									end;
								end;
							end;
						end;
					end;
				end;

			------------------------------------------------------------------------------------------------------------------------------------------------
			---------------------------------------------------------------WHEEL HUBS-----------------------------------------------------------------------
			------------------------------------------------------------------------------------------------------------------------------------------------	

				if self.spec_wheels ~= nil and self.spec_wheels.hubs ~= nil then
					for i, hub in pairs (self.spec_wheels.hubs) do
						if getHasShaderParameter(hub.node, "dirtColor") then
							local wheel = self.spec_wheels.wheels[i];
							if wheel ~= nil and wheel["wheelTire"] ~= nil then
								local HubDirtColR, HubDirtColG, HubDirtColB, _ = getShaderParameter(wheel["wheelTire"], "dirtColor");
								if HubDirtColR <= 0.0 then
									HubDirtColR, HubDirtColG, HubDirtColB = realDirtColor:findWheelDirtColor(wheel);
								end;
								setShaderParameter(hub.node, "dirtColor", HubDirtColR, HubDirtColG, HubDirtColB, 0, false);
							end;
						end;
					end;
				end;

			------------------------------------------------------------------------------------------------------------------------------------------------
			----------------------------------------------------------------CRAWLERS------------------------------------------------------------------------
			------------------------------------------------------------------------------------------------------------------------------------------------	
				if self.spec_crawlers ~= nil and self.spec_crawlers.crawlers ~= nil and #self.spec_crawlers.crawlers ~= 0 then
					for i, crawler in pairs(self.spec_crawlers.crawlers) do
						crawler = self.spec_crawlers.crawlers[i];
						if crawler.rDC ~= nil and crawler.rDC then
							local crawlerCurDirtCol = {};
							if (crawler.crawlerBase ~= nil and crawlerCurDirtCol.r == nil) and getHasShaderParameter(crawler.crawlerBase, "dirtColor") then
								crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, _  = getShaderParameter(crawler.crawlerBase, "dirtColor");
							
								local crawlerColorSpeed = realDirtColor.speeds.wheels;

								if (wetGround or rainWeather) and (crawler.newDirtColor == 0.1 or crawler.currentDirtColor == 0.1) then -- Change Dirt color to "Mud color" depending on ground moisture level.
									crawler.newDirtColor = 0.5;
									crawlerColorSpeed = crawlerColorSpeed * realDirtColor.speeds.boost; --Dirt to Mud Speed Boost.
								elseif (not wetGround and not rainWeather) and (crawler.newDirtColor == 0.5 or crawler.currentDirtColor == 0.5) then -- Change Dirt color back to "Dry Dirt" color.
									crawler.newDirtColor = 0.1;
								end;
								
								crawler.previousDirtColor, crawler.currentDirtColor, crawler.targetRDColor = realDirtColor:getNewColor(crawler.previousDirtColor, crawler.currentDirtColor, crawler.newDirtColor, crawler.targetRDColor);
								
								crawlerColorSpeed = realDirtColor:adjustColorSpeed(crawler.currentDirtColor, crawler.previousDirtColor, crawlerColorSpeed);

								if (crawlerCurDirtCol.r ~= crawler.targetRDColor.r) and (crawlerCurDirtCol.g ~= crawler.targetRDColor.g) and (crawlerCurDirtCol.b ~= crawler.targetRDColor.b) then

									if crawler.newDirtColor > 0.0 then
										crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b = realDirtColor:colorChangeFormula(crawlerCurDirtCol, crawler.targetRDColor, dt, crawlerColorSpeed);
									end;

									if crawler.lastColor ~= nil and crawler.onRoadSurface == nil then -- Update old Color information and (Bonus) Sets Driving PS Color
										crawler.lastColor = {crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0};
									end;
									
									if crawler.node ~= nil and getHasShaderParameter(crawler.node, "dirtColor") then
										setShaderParameter(crawler.node, "dirtColor", crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0, false);
									end;
									if crawler.crawlerBase ~= nil and getHasShaderParameter(crawler.crawlerBase, "dirtColor") then
										setShaderParameter(crawler.crawlerBase, "dirtColor", crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0, false);
									end;
									if crawler.shaderParameterComponent ~= nil and getHasShaderParameter(crawler.shaderParameterComponent, "dirtColor") then
										setShaderParameter(crawler.shaderParameterComponent, "dirtColor", crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0, false);
									end;
									if crawler.scrollerNodes ~= nil then
										for _, scrollerNode in pairs(crawler.scrollerNodes) do
											if scrollerNode.node ~= nil and getHasShaderParameter(scrollerNode.node, "dirtColor") then
												setShaderParameter(scrollerNode.node, "dirtColor", crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0, false);
											end;
										end;
									end;
									if crawler.rotatingParts ~= nil then
										for _, rotationPart in pairs(crawler.rotatingParts) do
											if rotationPart.node ~= nil then
												if getHasClassId(rotationPart.node, ClassIds.SHAPE) and getHasShaderParameter(rotationPart.node, "dirtColor") then
													setShaderParameter(rotationPart.node, "dirtColor", crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0, false);
												end;
												if getNumOfChildren(rotationPart.node) > 0 then
													for i=0, getNumOfChildren(rotationPart.node)-1 do
														local rotatorChild = getChildAt(rotationPart.node, i);
														if getHasClassId(rotatorChild, ClassIds.SHAPE) and getHasShaderParameter(rotatorChild, "dirtColor") then
															setShaderParameter(rotatorChild, "dirtColor", crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0, false);
														end;
													end;
												end;
											end;
										end;
									end;
									if crawler.additionalCrawlers ~= nil and #wheel.additionalCrawlers > 0 then
										for _, additionalWheel in pairs(wheel.additionalCrawlers) do	
											if additionalCrawler.node ~= nil and getHasShaderParameter(additionalCrawler.node, "dirtColor") then
												setShaderParameter(additionalCrawler.node, "dirtColor", crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0, false);
											end;
											if additionalCrawler.crawlerBase ~= nil and getHasShaderParameter(additionalCrawler.crawlerBase, "dirtColor") then
												setShaderParameter(additionalCrawler.crawlerBase, "dirtColor", crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0, false);
											end;
											if additionalCrawler.shaderParameterComponent ~= nil and getHasShaderParameter(additionalCrawler.shaderParameterComponent, "dirtColor") then
												setShaderParameter(additionalCrawler.shaderParameterComponent, "dirtColor", crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0, false);
											end;
											if additionalCrawler.scrollerNodes ~= nil then
												for _, scrollerNode in pairs(additionalCrawler.scrollerNodes) do
													if scrollerNode.node ~= nil and getHasShaderParameter(scrollerNode.node, "dirtColor") then
														setShaderParameter(scrollerNode.node, "dirtColor", crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0, false);
													end;
												end;
											end;
											if additionalCrawler.rotatingParts ~= nil then
												for _, rotationPart in pairs(additionalCrawler.rotatingParts) do
													if rotationPart.node ~= nil then
														if getHasClassId(rotationPart.node, ClassIds.SHAPE) and getHasShaderParameter(rotationPart.node, "dirtColor") then
															setShaderParameter(rotationPart.node, "dirtColor", crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0, false);
														end;
														if getNumOfChildren(rotationPart.node) > 0 then
															for i=0, getNumOfChildren(rotationPart.node)-1 do
																local rotatorChild = getChildAt(rotationPart.node, i);
																if getHasClassId(rotatorChild, ClassIds.SHAPE) and getHasShaderParameter(rotatorChild, "dirtColor") then
																	setShaderParameter(rotatorChild, "dirtColor", crawlerCurDirtCol.r, crawlerCurDirtCol.g, crawlerCurDirtCol.b, 0, false);
																end;
															end;
														end;
													end;
												end;
											end;
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			end;

------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------Terrain Detection for Color---------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

		---------------------------------------------------------------------------------------------
		-------------------------------------BODYPARTS-----------------------------------------------
		---------------------------------------------------------------------------------------------

	--------------------------------------FILL-TYPES------(FillPlane Detection)-------------------------------------------------------
			local foundFillType = DensityMapHeightUtil.getFillTypeAtLine(x0, y0, z0, x1, y0, z1, 1.0);

			if realDirtColor.debugging then
				local r = math.random(0.00,1.00);
				local g = math.random(0.00,1.00);
				local b = math.random(0.00,1.00);
				if b == r or b == g then
					b = math.random(0.00,1.00);
				end;
				if g == b or g == r then
					g = math.random(0.00,1.00);
				end;
				drawDebugLine(x0,y0,z0, r,g,b, x1,y0,z1, r,g,b);--RDC Rainbow Line
			end;

			if foundFillType == FillType.SNOW then
				if self.newDirtColor ~= 2 then
					self.newDirtColor = 2;
					--if realDirtColor.debugging then
					--	print("Found SNOW");
					--end;
				end;
			elseif foundFillType == FillType.MANURE then
				if self.newDirtColor ~= 4 then
					self.newDirtColor = 4;
					--if realDirtColor.debugging then
					--	print("Found MANURE");
					--end;
				end;
			elseif foundFillType == FillType.GRASS_WINDROW then
				if self.newDirtColor ~= 1 then
					self.newDirtColor = 1;
					--if realDirtColor.debugging then
					--	print("Found GRASS");
					--end;
				end;
			elseif foundFillType == FillType.DRYGRASS_WINDROW then
				if self.newDirtColor ~= 1 then
					self.newDirtColor = 1;
					--if realDirtColor.debugging then
					--	print("Found DRYGRASS");
					--end;
				end;
			elseif foundFillType == FillType.CHAFF then
				if self.newDirtColor ~= 1.5 then
					self.newDirtColor = 1.5;
					--if realDirtColor.debugging then
					--	print("Found CHAFF");
					--end;
				end;
			elseif foundFillType == FillType.LIME then
				if self.newDirtColor ~= 3 then
					self.newDirtColor = 3;
					--if realDirtColor.debugging then
					--	print("Found LIME");
					--end;
				end;
			elseif foundFillType == FillType.MUD then
				if self.newDirtColor ~= 0.55 then
					self.newDirtColor = 0.55;
					--if realDirtColor.debugging then
					--	print("Found MUD");
					--end;
				end;
			else
	--------------------------------------FRUIT-TYPES------(Surface Texture Detection)-------------------------------------------------
				local sprayedFruitColor = 0;
				local dirtDetected = false;
				local fruitCheck = g_currentMission.fieldCropsQuery;
				local grassDesc = g_fruitTypeManager:getFruitTypeByIndex(FruitType.GRASS);
				local grassids = g_currentMission.fruits[FruitType.GRASS];

				-----------------------------------------------------------------------------

				if grassDesc ~= nil and grassids ~= nil then
					local xl, zl, widthX, widthZ, heightX, heightZ = MathUtil.getXZWidthAndHeight(x0, z0, x1, z1, x0, z0);			
					fruitCheck:addRequiredCropType(grassids.id, grassDesc.minHarvestingGrowthState+1, grassDesc.maxHarvestingGrowthState+1, grassDesc.startStateChannel, grassDesc.numStateChannels, 0, g_currentMission.terrainDetailTypeNumChannels);
					local grassArea, _ = fruitCheck:getParallelogram(xl,zl, widthX,widthZ, heightX,heightZ, true);

					if grassArea > 0 and sprayedFruitColor ~= 1 then
						--if realDirtColor.debugging then
						--	print("Found Grass Surface");
						--end;
						sprayedFruitColor = 1;
					elseif sprayedFruitColor ~= 0.0 then
						sprayedFruitColor = 0.0;
					end;
				end;

	--------------------------------------SPRAY-TYPES------(Surface Texture Detection & General Field Detection)-----------------------
				if (g_currentMission.terrainDetailId ~= nil) and (sprayedFruitColor == 0.0) and (dirtDetected == false) then
					local bits = getDensityAtWorldPos(g_currentMission.terrainDetailId, x, y0, z);
					if bits ~= 0 then--is on a field
						dirtDetected = true;
						--sprayedFruitColor = realDirtColor:determineSpray(bits);
						--[[if realDirtColor.debugging then
							if Input.isKeyPressed(Input.KEY_lalt) and Input.isKeyPressed(Input.KEY_1) then
								print(bits);
							end;
						end;]]
						for sprayType, filltype in pairs({FillType.LIME, FillType.MANURE, FillType.LIQUIDMANURE, FillType.DIGESTATE}) do
							local sprayTypeDesc = g_sprayTypeManager:getSprayTypeByFillTypeIndex(filltype);
							if sprayTypeDesc ~= nil then
								local sprayCheck = g_currentMission.fieldCropsQuery;
								local xl, zl, widthX, widthZ, heightX, heightZ = MathUtil.getXZWidthAndHeight(x0, z0, x1, z1, x0, z0);
								sprayCheck:addRequiredGroundValue(sprayTypeDesc.groundType, sprayTypeDesc.groundType, g_currentMission.sprayFirstChannel, g_currentMission.sprayNumChannels);
								--sprayCheck:addRequiredGroundValue(g_currentMission.sprayLevelMaxValue, g_currentMission.sprayLevelMaxValue, g_currentMission.sprayLevelFirstChannel, g_currentMission.sprayLevelNumChannels)
								local totalArea, _ = sprayCheck:getParallelogram(xl,zl, widthX,widthZ, heightX,heightZ, true);
					
								if totalArea > 0 then
									if sprayType == 1 and sprayedFruitColor ~= 3 then
										--[[if realDirtColor.debugging then
											if Input.isKeyPressed(Input.KEY_ralt) and Input.isKeyPressed(Input.KEY_9) then
												print("Found Lime Surface");
											end;
										end;]]
										sprayedFruitColor = 3;
									elseif sprayType == 2 and sprayedFruitColor ~= 4 then
										--[[if realDirtColor.debugging then
											if Input.isKeyPressed(Input.KEY_ralt) and Input.isKeyPressed(Input.KEY_9) then
												print("Found Manure Surface");
											end;
										end;]]
										sprayedFruitColor = 4;
									elseif sprayType >= 3 and sprayedFruitColor ~= 5 then
										--[[if realDirtColor.debugging then
											if Input.isKeyPressed(Input.KEY_ralt) and Input.isKeyPressed(Input.KEY_9) then
												print("Found Slurry Surface: "..sprayType);
											end;
										end;]]
										sprayedFruitColor = 5;
									end;
								end;
							end;
						end;
					end;
				end;

	---------------------------------------------------Texture Detection---------------------------------------------------------------

				if (sprayedFruitColor == 0.0) and (dirtDetected == false) then
					local cR,cG,cB,_,_ = getTerrainAttributesAtWorldPos(g_currentMission.terrainRootNode, x, y0, z, true, true, true, true, false);
					if self.dryDirtColor == 0 then
						if (cR > 0.15500 and cR < 0.15501) and (cG > 0.08200 and cG < 0.08201) and (cB > 0.03700 and cB < 0.03701) then -- Dirt Terrain
							dirtDetected = true;
						end;
					else
						if (cR > 0.36 and cR < 0.36001) and (cG > 0.12499 and cG < 0.12501) and (cB > 0.056 and cB < 0.05601) then --redDirt Terrain
							dirtDetected = true;
						end;
					end;
					--[[if realDirtColor.debugging then
						if Input.isKeyPressed(Input.KEY_lctrl) and Input.isKeyPressed(Input.KEY_2) then
							print("R: "..cR.." | G: "..cG.." | B: "..cB.." |");
						end;
					end;]]
				end;
	-----------------------------------------------------------------------------------------------------------------------------------

				if sprayedFruitColor > 0 and self.newDirtColor ~= sprayedFruitColor then
					self.newDirtColor = sprayedFruitColor;  
				elseif sprayedFruitColor == 0 and dirtDetected and self.newDirtColor ~= 0.1 then
					self.newDirtColor = 0.1;
				elseif self.newDirtColor ~= 0.0 then
					self.newDirtColor = 0.0; -- Stay the same color
				end;

			end;

	-----------------------------------------------------------------------------------------------------------------------------------	
			if not realDirtColor.simpleMode and self.tooManyWheelsRDC == nil then
			---------------------------------------------------------------------------------------------
			-----------------------------Terrain Detection for Color-------------------------------------
			--------------------------------------WHEELS-------------------------------------------------
			---------------------------------------------------------------------------------------------
				--local hasCrawlers = false;
				--if self.spec_crawlers ~= nil and self.spec_crawlers.crawlers ~= nil and #self.spec_crawlers.crawlers ~= 0 then
				--	hasCrawlers = true;
				--end;
				if self.spec_wheels ~= nil and self.spec_wheels.wheels ~= nil and #self.spec_wheels.wheels > 0 then --and not hasCrawlers then
					for i, wheel in pairs(self.spec_wheels.wheels) do
						wheel = self.spec_wheels.wheels[i];
						if wheel.rDC ~= nil and wheel.rDC then
							--local wheelX, wheelY, wheelZ = getWorldTranslation(wheel.repr);
							--if wheel.driveNode ~= nil then
							local wheelX, wheelY, wheelZ = getWorldTranslation(wheel.driveNode);
							--end;
							local wheelXOffset = 0;
							local newWheelWidth = wheel.width;
							if wheel.additionalWheels ~= nil and #wheel.additionalWheels > 0 then -- increase wheel detecting area.
								newWheelWidth = newWheelWidth * (#wheel.additionalWheels+1);--plus base wheel
								if wheel.isLeft then
									wheelXOffset = wheelXOffset + newWheelWidth;
								else
									wheelXOffset = wheelXOffset - newWheelWidth;
								end;
							end;

							newWheelWidth = newWheelWidth / 2;
							if wheel.additionalWheels ~= nil and #wheel.additionalWheels > 0 then
								if wheel.isLeft and wheelXOffset ~= 0 then
									wheelXOffset = -newWheelWidth + wheelXOffset;
								else
									wheelXOffset = newWheelWidth + wheelXOffset;
								end;
							end;
							local wheelx0, _, wheelz0 = localToWorld(wheel.driveNode, wheelXOffset+newWheelWidth, 0, 0);
							local wheelx1, _, wheelz1 = localToWorld(wheel.driveNode, wheelXOffset-newWheelWidth, 0, 0);
							local wheely0 = wheelY - (wheel.radius-0.001); --DensityMapHeightUtil.getHeightAtWorldPos(wheelX, wheelY, wheelZ);
							if realDirtColor.debugging then
								if i == 1 then
									drawDebugLine(wheelx0,wheely0,wheelz0, 0,0,1, wheelx1,wheely0,wheelz1, 0,0,1);
								elseif i == 2 then
									drawDebugLine(wheelx0,wheely0,wheelz0, 0,1,0, wheelx1,wheely0,wheelz1, 0,1,0);
								elseif i == 3 then
									drawDebugLine(wheelx0,wheely0,wheelz0, 1,0,0, wheelx1,wheely0,wheelz1, 1,0,0);
								else
									drawDebugLine(wheelx0,wheely0,wheelz0, 1,0,1, wheelx1,wheely0,wheelz1, 1,0,1);
								end;
							end;

						--------------------------------------FILL-TYPES------(FillPlane Detection)-------------------------------------------------------
							local foundFillType = DensityMapHeightUtil.getFillTypeAtLine(wheelx0, wheely0, wheelz0, wheelx1, wheely0, wheelz1, 1.0);
							if foundFillType == FillType.SNOW then
								if wheel.newDirtColor ~= 2 then
									wheel.newDirtColor = 2;
								end;
							elseif foundFillType == FillType.MANURE then
								if wheel.newDirtColor ~= 4 then
									wheel.newDirtColor = 4;
								end;
							elseif foundFillType == FillType.GRASS_WINDROW then
								if wheel.newDirtColor ~= 1 then
									wheel.newDirtColor = 1;
								end;
							elseif foundFillType == FillType.DRYGRASS_WINDROW then
								if wheel.newDirtColor ~= 1 then
									wheel.newDirtColor = 1;
								end;
							elseif foundFillType == FillType.CHAFF then
								if wheel.newDirtColor ~= 1.5 then
									wheel.newDirtColor = 1.5;
								end;
							elseif foundFillType == FillType.LIME then
								if wheel.newDirtColor ~= 3 then
									wheel.newDirtColor = 3;
								end;
							elseif foundFillType == FillType.MUD then
								if wheel.newDirtColor ~= 0.55 then
									wheel.newDirtColor = 0.55;
								end;
							else
					--------------------------------------FRUIT-TYPES------(Surface Texture Detection)-------------------------------------------------
								local wheelSprayedFruitColor = 0;
								local wheeldirtDetected = false;
								local fruitCheck = g_currentMission.fieldCropsQuery;
								local grassDesc = g_fruitTypeManager:getFruitTypeByIndex(FruitType.GRASS);
								local grassids = g_currentMission.fruits[FruitType.GRASS];
								-----------------------------------------------------------------------------

								if grassDesc ~= nil and grassids ~= nil then

									local xl, zl, widthX, widthZ, heightX, heightZ = MathUtil.getXZWidthAndHeight(wheelx0, wheelz0, wheelx1, wheelz1, wheelx0, wheelz0);
									fruitCheck:addRequiredCropType(grassids.id, grassDesc.minHarvestingGrowthState+1, grassDesc.maxHarvestingGrowthState+1, grassDesc.startStateChannel, grassDesc.numStateChannels, 0, g_currentMission.terrainDetailTypeNumChannels)
									local grassArea, _ = fruitCheck:getParallelogram(xl,zl, widthX,widthZ, heightX,heightZ, true);

									if grassArea > 0 and wheelSprayedFruitColor ~= 1 then
										wheelSprayedFruitColor = 1;
									elseif wheelSprayedFruitColor ~= 0 then
										wheelSprayedFruitColor = 0.0;
									end;

								end;
								
					--------------------------------------SPRAY-TYPES------(Surface Texture Detection & General Field Detection)-----------------------
								if (g_currentMission.terrainDetailId ~= nil) and (wheelSprayedFruitColor == 0.0) and (wheeldirtDetected == false) then
									local bits = getDensityAtWorldPos(g_currentMission.terrainDetailId, wheelX, wheely0, wheelZ);
									if bits ~= 0 then --is on a field
										wheeldirtDetected = true;
										--wheelSprayedFruitColor = realDirtColor:determineSpray(bits);
										for sprayType, filltype in pairs({FillType.LIME, FillType.MANURE, FillType.LIQUIDMANURE, FillType.DIGESTATE}) do
											local sprayTypeDesc = g_sprayTypeManager:getSprayTypeByFillTypeIndex(filltype);
											if sprayTypeDesc ~= nil then
												local sprayCheck = g_currentMission.fieldCropsQuery;
												local xl, zl, widthX, widthZ, heightX, heightZ = MathUtil.getXZWidthAndHeight(wheelx0, wheelz0, wheelx1, wheelz1, wheelx0, wheelz0);
												sprayCheck:addRequiredGroundValue(sprayTypeDesc.groundType, sprayTypeDesc.groundType, g_currentMission.sprayFirstChannel, g_currentMission.sprayNumChannels);
												local totalArea, _ = sprayCheck:getParallelogram(xl,zl, widthX,widthZ, heightX,heightZ, true);
												if totalArea > 0 then
													if sprayType == 1 and wheelSprayedFruitColor ~= 3 then
														wheelSprayedFruitColor = 3;
													elseif sprayType == 2 and wheelSprayedFruitColor ~= 4 then
														wheelSprayedFruitColor = 4;
													elseif sprayType >= 3 and wheelSprayedFruitColor ~= 5 then
														wheelSprayedFruitColor = 5;
													end;
												end;
											end;
										end;
									end;
								end;

					---------------------------------------------------Texture Detection---------------------------------------------------------------

								if (wheelSprayedFruitColor == 0.0) and (wheeldirtDetected == false) then
									local cR,cG,cB,_,_ = getTerrainAttributesAtWorldPos(g_currentMission.terrainRootNode, wheelX, wheely0, wheelZ, true, true, true, true, false);
									if self.dryDirtColor == 0 then
										if (cR > 0.15500 and cR < 0.15501) and (cG > 0.08200 and cG < 0.08201) and (cB > 0.03700 and cB < 0.03701) then -- Dirt Terrain
											wheeldirtDetected = true;
										end;
									else
										if (cR > 0.36 and cR < 0.36001) and (cG > 0.12499 and cG < 0.12501) and (cB > 0.056 and cB < 0.05601) then --redDirt Terrain
											wheeldirtDetected = true;
										end;
									end;
									if ((cR > 0.4 ) and (cG > 0.4) and (cB > 0.4)) and wheel.onRoadSurface == nil then -- Road Surface
										wheel.onRoadSurface = true;
									elseif wheel.onRoadSurface ~= nil then
										wheel.onRoadSurface = nil;
									end;
								end;

					-----------------------------------------------------------------------------------------------------------------------------------
								if wheelSprayedFruitColor > 0 and wheel.newDirtColor ~= wheelSprayedFruitColor  then
									wheel.newDirtColor = wheelSprayedFruitColor; 
								elseif wheelSprayedFruitColor == 0 and wheeldirtDetected and wheel.newDirtColor ~= 0.1 then
									wheel.newDirtColor = 0.1;
								elseif wheel.newDirtColor ~= 0.0 then
									wheel.newDirtColor = 0.0; -- Stay the same color
								end;

							end;
						end;
				-----------------------------------------------------------------------------------------------------------------------------------
					end;
				end;
			---------------------------------------------------------------------------------------------
			-----------------------------Terrain Detection for Color-------------------------------------
			--------------------------------------CRAWLERS-----------------------------------------------
			---------------------------------------------------------------------------------------------
				if self.spec_crawlers ~= nil and self.spec_crawlers.crawlers ~= nil and #self.spec_crawlers.crawlers ~= 0 then -- if hasCrawlers then
					for i, crawler in pairs(self.spec_crawlers.crawlers) do
						crawler = self.spec_crawlers.crawlers[i];
						if crawler.rDC ~= nil and crawler.rDC then
							local crawlerX, crawlerY, crawlerZ = getWorldTranslation(crawler.crawlerBase);
							crawlerY = y + 0.001;
							local newWheelWidth = crawler.trackWidth;
							local wheelXOffset = 0;
							if crawler.additionalCrawlers ~= nil and #crawler.additionalCrawlers > 0 then -- increase detecting area.
								newWheelWidth = newWheelWidth * (#crawler.additionalCrawlers+1);
								if crawler.isLeft then
									wheelXOffset = wheelXOffset + newWheelWidth;
								else
									wheelXOffset = wheelXOffset - newWheelWidth;
								end;
							end;

							newWheelWidth = newWheelWidth / 2;
							if crawler.additionalCrawlers ~= nil and #crawler.additionalCrawlers > 0 then
								if crawler.isLeft and wheelXOffset ~= 0 then
									wheelXOffset = -newWheelWidth + wheelXOffset;
								else
									wheelXOffset = newWheelWidth + wheelXOffset;
								end;
							end;
							local crawlerx0, _, crawlerz0 = localToWorld(crawler.crawlerBase, wheelXOffset+newWheelWidth, 0, newWheelWidth*3);-- 3 * 1/2
							local crawlerx1, _, crawlerz1 = localToWorld(crawler.crawlerBase, wheelXOffset-newWheelWidth, 0, newWheelWidth*3);

							if realDirtColor.debugging then
								if i == 1 then
									drawDebugLine(crawlerx0,crawlerY,crawlerz0, 0,0,1, crawlerx1,crawlerY,crawlerz1, 0,0,1);
								elseif i == 2 then
									drawDebugLine(crawlerx0,crawlerY,crawlerz0, 0,1,0, crawlerx1,crawlerY,crawlerz1, 0,1,0);
								elseif i == 3 then
									drawDebugLine(crawlerx0,crawlerY,crawlerz0, 1,0,0, crawlerx1,crawlerY,crawlerz1, 1,0,0);
								else
									drawDebugLine(crawlerx0,crawlerY,crawlerz0, 1,0,1, crawlerx1,crawlerY,crawlerz1, 1,0,1);
								end;
							end;

						--------------------------------------FILL-TYPES------(FillPlane Detection)-------------------------------------------------------
							local foundFillType = DensityMapHeightUtil.getFillTypeAtLine(crawlerx0, crawlerY, crawlerz0, crawlerx1, crawlerY, crawlerz1, 1.0);
							if foundFillType == FillType.SNOW then
								if crawler.newDirtColor ~= 2 then
									crawler.newDirtColor = 2;
								end;
							elseif foundFillType == FillType.MANURE then
								if crawler.newDirtColor ~= 4 then
									crawler.newDirtColor = 4;
								end;
							elseif foundFillType == FillType.GRASS_WINDROW then
								if crawler.newDirtColor ~= 1 then
									crawler.newDirtColor = 1;
								end;
							elseif foundFillType == FillType.DRYGRASS_WINDROW then
								if crawler.newDirtColor ~= 1 then
									crawler.newDirtColor = 1;
								end;
							elseif foundFillType == FillType.CHAFF then
								if crawler.newDirtColor ~= 1.5 then
									crawler.newDirtColor = 1.5;
								end;
							elseif foundFillType == FillType.LIME then
								if crawler.newDirtColor ~= 3 then
									crawler.newDirtColor = 3;
								end;
							elseif foundFillType == FillType.MUD then
								if crawler.newDirtColor ~= 0.55 then
									crawler.newDirtColor = 0.55;
								end;
							else
					--------------------------------------FRUIT-TYPES------(Surface Texture Detection)-------------------------------------------------
								local crawlerSprayedFruitColor = 0;
								local crawlerDirtDetected = false;
								local fruitCheck = g_currentMission.fieldCropsQuery;
								local grassDesc = g_fruitTypeManager:getFruitTypeByIndex(FruitType.GRASS);
								local grassids = g_currentMission.fruits[FruitType.GRASS];
								-----------------------------------------------------------------------------

								if grassDesc ~= nil and grassids ~= nil then

									local xl, zl, widthX, widthZ, heightX, heightZ = MathUtil.getXZWidthAndHeight(crawlerx0, crawlerz0, crawlerx1, crawlerz1, crawlerx0, crawlerz0);
									fruitCheck:addRequiredCropType(grassids.id, grassDesc.minHarvestingGrowthState+1, grassDesc.maxHarvestingGrowthState+1, grassDesc.startStateChannel, grassDesc.numStateChannels, 0, g_currentMission.terrainDetailTypeNumChannels)									
									local grassArea, _ = fruitCheck:getParallelogram(xl,zl, widthX,widthZ, heightX,heightZ, true);

									if grassArea > 0 and crawlerSprayedFruitColor ~= 1 then
										crawlerSprayedFruitColor = 1;
									elseif crawlerSprayedFruitColor ~= 0 then
										crawlerSprayedFruitColor = 0.0;
									end;

								end;
					
					--------------------------------------SPRAY-TYPES------(Surface Texture Detection & General Field Detection)-----------------------

								if (g_currentMission.terrainDetailId ~= nil) and (crawlerSprayedFruitColor == 0.0) and (crawlerDirtDetected == false) then
									local bits = getDensityAtWorldPos(g_currentMission.terrainDetailId, crawlerX, crawlerY, crawlerZ);
									if bits ~= 0 then--is on a field
										crawlerDirtDetected = true;
										--crawlerSprayedFruitColor = realDirtColor:determineSpray(bits);
										for sprayType, filltype in pairs({FillType.LIME, FillType.MANURE, FillType.LIQUIDMANURE, FillType.DIGESTATE}) do
											local sprayTypeDesc = g_sprayTypeManager:getSprayTypeByFillTypeIndex(filltype);
											if sprayTypeDesc ~= nil then
												local sprayCheck = g_currentMission.fieldCropsQuery;
												local xl, zl, widthX, widthZ, heightX, heightZ = MathUtil.getXZWidthAndHeight(crawlerx0, crawlerz0, crawlerx1, crawlerz1, crawlerx0, crawlerz0);
												sprayCheck:addRequiredGroundValue(sprayTypeDesc.groundType, sprayTypeDesc.groundType, g_currentMission.sprayFirstChannel, g_currentMission.sprayNumChannels);
												local totalArea, _ = sprayCheck:getParallelogram(xl,zl, widthX,widthZ, heightX,heightZ, true);
												if totalArea > 0 then
													if sprayType == 1 and crawlerSprayedFruitColor ~= 3 then
														crawlerSprayedFruitColor = 3;
													elseif sprayType == 2 and crawlerSprayedFruitColor ~= 4 then
														crawlerSprayedFruitColor = 4;
													elseif sprayType >= 3 and crawlerSprayedFruitColor ~= 5 then
														crawlerSprayedFruitColor = 5;
													end;
												end;
											end;
										end;
									end;
								end;

					---------------------------------------------------Texture Detection---------------------------------------------------------------

								if (crawlerSprayedFruitColor == 0.0) and (crawlerDirtDetected == false) then
									local cR,cG,cB,_,_ = getTerrainAttributesAtWorldPos(g_currentMission.terrainRootNode, crawlerX, crawlerY, crawlerZ, true, true, true, true, false);
									if self.dryDirtColor == 0 then
										if (cR > 0.15500 and cR < 0.15501) and (cG > 0.08200 and cG < 0.08201) and (cB > 0.03700 and cB < 0.03701) then -- Dirt Terrain
											crawlerDirtDetected = true;
										end;
									else
										if (cR > 0.36 and cR < 0.36001) and (cG > 0.12499 and cG < 0.12501) and (cB > 0.056 and cB < 0.05601) then --redDirt Terrain
											crawlerDirtDetected = true;
										end;
									end;
									if ((cR > 0.4 ) and (cG > 0.4) and (cB > 0.4)) and crawler.onRoadSurface == nil then -- Road Surface
										crawler.onRoadSurface = true;
									elseif crawler.onRoadSurface ~= nil then
										crawler.onRoadSurface = nil;
									end;
								end;

					-----------------------------------------------------------------------------------------------------------------------------------

								if crawlerSprayedFruitColor > 0 and crawler.newDirtColor ~= crawlerSprayedFruitColor then
									crawler.newDirtColor = crawlerSprayedFruitColor; 
								elseif crawlerSprayedFruitColor == 0 and crawlerDirtDetected and crawler.newDirtColor ~= 0.1 then
									crawler.newDirtColor = 0.1;
								elseif crawler.newDirtColor ~= 0.0 then
									crawler.newDirtColor = 0.0; --Stay the Same color
								end;

							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function realDirtColor:getNewColor(previousDirtColor, currentDirtColor, newDirtColor, targetRDColor)

	local rDColors = realDirtColor.colors;

	if newDirtColor == 5  and currentDirtColor ~= 5 then --Slurry
		targetRDColor.r, targetRDColor.g, targetRDColor.b = rDColors.slurry.r, rDColors.slurry.g, rDColors.slurry.b;
		previousDirtColor = currentDirtColor;
		currentDirtColor = 5;
	elseif newDirtColor == 4  and currentDirtColor ~= 4 then --Manure
		targetRDColor.r, targetRDColor.g, targetRDColor.b = rDColors.manure.r, rDColors.manure.g, rDColors.manure.b;
		previousDirtColor = currentDirtColor;
		currentDirtColor = 4;
	elseif newDirtColor == 3  and currentDirtColor ~= 3 then --Lime
		targetRDColor.r, targetRDColor.g, targetRDColor.b = rDColors.lime.r, rDColors.lime.g, rDColors.lime.b;
		previousDirtColor = currentDirtColor;
		currentDirtColor = 3;
	elseif newDirtColor == 2  and currentDirtColor ~= 2 then --Snow
		targetRDColor.r, targetRDColor.g, targetRDColor.b = rDColors.snow.r, rDColors.snow.g, rDColors.snow.b;
		previousDirtColor = currentDirtColor;
		currentDirtColor = 2;
	elseif newDirtColor == 1.5 and currentDirtColor ~= 1.5 then -- Chaff
		targetRDColor.r, targetRDColor.g, targetRDColor.b = rDColors.chaff.r, rDColors.chaff.g, rDColors.chaff.b;
		previousDirtColor = currentDirtColor;
		currentDirtColor = 1.5;
	elseif newDirtColor == 1 and currentDirtColor ~= 1 then --Grass
		targetRDColor.r, targetRDColor.g, targetRDColor.b = rDColors.grass.r, rDColors.grass.g, rDColors.grass.b;
		previousDirtColor = currentDirtColor;
		currentDirtColor = 1;
	elseif newDirtColor == 0.5 and currentDirtColor ~= 0.5 then -- Mud (Field)
		targetRDColor.r, targetRDColor.g, targetRDColor.b = rDColors.mud.r, rDColors.mud.g, rDColors.mud.b;
		previousDirtColor = currentDirtColor;
		currentDirtColor = 0.5;
	elseif newDirtColor == 0.55 and currentDirtColor ~= 0.55 then -- Mud (FillType)
		targetRDColor.r, targetRDColor.g, targetRDColor.b = rDColors.mud.r, rDColors.mud.g, rDColors.mud.b;
		previousDirtColor = currentDirtColor;
		currentDirtColor = 0.55;
	elseif newDirtColor == 0.1 and currentDirtColor ~= 0.1 then -- Dirt
		targetRDColor.r, targetRDColor.g, targetRDColor.b = rDColors.dryDirt.r, rDColors.dryDirt.g, rDColors.dryDirt.b;
		previousDirtColor = currentDirtColor;
		currentDirtColor = 0.1;
	end;

	return previousDirtColor, currentDirtColor, targetRDColor;

end;

function realDirtColor:colorChangeFormula(CurrentRDCol, TargetRDColor, dt, colorSpeed)
	-----------------VCCF Interpolation (VIPER'S COLOR CHANGE FORMULA)-----------------
	--[[ Unfortunately the lerp function performs a better color change to and from white..
	if CurrentRDCol.r ~= TargetRDColor.r then
		if CurrentRDCol.r > TargetRDColor.r then -- Red Color Channel
			local rValDifference = CurrentRDCol.r / TargetRDColor.r;
			CurrentRDCol.r = (CurrentRDCol.r - (TargetRDColor.r * (dt * (colorSpeed * rValDifference))));
			print("r:");
			print(rValDifference);
			print(TargetRDColor.r * (dt * (colorSpeed * rValDifference)));
		else
			local rValDifference = TargetRDColor.r / CurrentRDCol.r;
			CurrentRDCol.r = (CurrentRDCol.r + (TargetRDColor.r * (dt * (colorSpeed * rValDifference))));
		end;
	end;
	
	if CurrentRDCol.g ~= TargetRDColor.g then
		if CurrentRDCol.g > TargetRDColor.g then -- Green Color Channel
			local gValDifference = CurrentRDCol.g / TargetRDColor.g;
			CurrentRDCol.g = (CurrentRDCol.g - (TargetRDColor.g * (dt * (colorSpeed * gValDifference))));
			print("g:");
			print(gValDifference);
			print(TargetRDColor.g * (dt * (colorSpeed * gValDifference)));
		else
			local gValDifference = TargetRDColor.g / CurrentRDCol.g;
			CurrentRDCol.g = (CurrentRDCol.g + (TargetRDColor.g * (dt * (colorSpeed * gValDifference))));
		end;
	end;
	
	if CurrentRDCol.b ~= TargetRDColor.b then
		if CurrentRDCol.b > TargetRDColor.b then -- Blue Color Channel     if PreviousRDColor.b > TargetRDColor.b then
			local bValDifference = CurrentRDCol.b / TargetRDColor.b; PreviousRDColor.b / TargetRDColor.b;
			CurrentRDCol.b = (CurrentRDCol.b - (TargetRDColor.b * (dt * (colorSpeed * bValDifference))));
			print("b:");
			print(bValDifference);
			print(TargetRDColor.b * (dt * (colorSpeed * bValDifference)));
		else
			local bValDifference =  TargetRDColor.b / CurrentRDCol.b;
			CurrentRDCol.b = (CurrentRDCol.b + (TargetRDColor.b * (dt * (colorSpeed * bValDifference))));
		end;
	end;--If this method is uncommented and tested, the main color speeds should be slower by 100x (eg.0.1 to 0.001)
	]]
	CurrentRDCol.r, CurrentRDCol.g, CurrentRDCol.b = MathUtil.vector3Lerp(CurrentRDCol.r, CurrentRDCol.g, CurrentRDCol.b, TargetRDColor.r, TargetRDColor.g, TargetRDColor.b, colorSpeed);

	return CurrentRDCol.r, CurrentRDCol.g, CurrentRDCol.b;

end;

function realDirtColor:determineSpray(bits)

	local sprayedColor = 0.0;

	if sprayedColor ~= 3 then
		for _, rdcBits in pairs(realDirtColor.bits.lime) do
			if bits == rdcBits then
				sprayedColor = 3;
				--if realDirtColor.debugging then
				--	print("Lime Detected and RDC Color Set");
				--end;
			end;
		end;
	end;
	if sprayedColor ~= 4 then
		for _, rdcBits in pairs(realDirtColor.bits.manure) do
			if bits == rdcBits then
				sprayedColor = 4;
				--if realDirtColor.debugging then
				--	print("Manure Detected and RDC Color Set");
				--end;
			end;
		end;
	end;
	if sprayedColor ~= 5 then
		for _, rdcBits in pairs(realDirtColor.bits.slurry) do
			if bits == rdcBits then
				sprayedColor = 5;
				--if realDirtColor.debugging then
				--	print("Slurry Detected and RDC Color Set");
				--end;
			end;
		end;
	end;

	return sprayedColor;

end;

function realDirtColor:adjustColorSpeed(currentDirtColor, previousDirtColor, colorSpeed)

	if currentDirtColor == 5 then
		colorSpeed = colorSpeed * realDirtColor.speeds.megaBoost;
	elseif previousDirtColor == 4 and currentDirtColor == 0.01 then--manure
		colorSpeed = colorSpeed * realDirtColor.speeds.revert;
	elseif currentDirtColor == 2 or currentDirtColor == 3 then--white
		colorSpeed = colorSpeed / realDirtColor.speeds.white;
	elseif previousDirtColor == 2 or previousDirtColor == 3 then--white
		colorSpeed = colorSpeed * (realDirtColor.speeds.revert - 2);
	elseif currentDirtColor == 0.55 or currentDirtColor == 0.5 then
		colorSpeed = colorSpeed * realDirtColor.speeds.boost;
	elseif previousDirtColor == 0.55 or previousDirtColor == 0.5 and currentDirtColor == 0.1 then
		colorSpeed = colorSpeed / realDirtColor.speeds.revertMud;
	elseif currentDirtColor == 0.1 and (previousDirtColor < 2 and previousDirtColor > 4) then
		colorSpeed = colorSpeed / realDirtColor.speeds.revert;
	end;

	return colorSpeed;

end;

function realDirtColor:addPart(table, partToadd)
--"table" can be "self" or a wheel
	if table.bodypart ~= nil then
		table.bodypart[#table.bodypart+1] = partToAdd;
	end;
end;

function realDirtColor:removePart(self, partToRemove)

	if self ~= nil and partToRemove ~= nil then
		if self.bodypart ~= nil then
			for partIndex, part in pairs(self.bodypart) do
				if part == partToRemove then
					table.remove(self.bodypart, partIndex);
					if realDirtColor.debugging then
						print("RDC: Part succesfully removed");
					end;
					return true;
				end;
			end;
		end;
		if self.spec_wheels.wheels ~= nil then
			for i, wheel in pairs(self.spec_wheels.wheels) do
				wheel = self.spec_wheels.wheels[i];
				if wheel.bodypart ~= nil then
					for partIndex, wpart in pairs(wheel.bodypart) do
						if wpart == partToRemove then
							table.remove(wheel.bodypart, partIndex);
							if realDirtColor.debugging then
								print("RDC: Wheel part succesfully removed");
							end;
							return true;
						end;
					end;
				end;
			end;	
		end;
	else
		if realDirtColor.debugging then
			print("RDC: Wheel part unsuccesfully removed; Unable to find part.");
		end;
		return false;
	end;

end;

function realDirtColor:findWheelDirtColor(wheel)

local rValue, gValue, bValue = 0,0,0;

	if wheel["wheelOuterRim"] ~= nil and getHasShaderParameter(wheel["wheelOuterRim"], "dirtColor") then
		rValue, gValue, bValue, _  = getShaderParameter(wheel["wheelOuterRim"], "dirtColor");
		if rValue > 0.0 then
			return rValue, gValue, bValue;
		end;
	end;

	if rValue <= 0.0 and wheel["wheelInnerRim"] ~= nil and getHasShaderParameter(wheel["wheelInnerRim"], "dirtColor") then
		rValue, gValue, bValue, _  = getShaderParameter(wheel["wheelInnerRim"], "dirtColor");
		if rValue > 0.0 then
			return rValue, gValue, bValue;
		end;
	end;

	if rValue <= 0.0 and  wheel["wheelAdditional"] ~= nil and getHasShaderParameter(wheel["wheelAdditional"], "dirtColor") then
		rValue, gValue, bValue, _  = getShaderParameter(wheel["wheelAdditional"], "dirtColor");
		if rValue > 0.0 then
			return rValue, gValue, bValue;
		end;
	end;

	if rValue <= 0.0 and wheel.bodypart ~= nil then
		for _, part in pairs(wheel.bodypart) do
			rValue, gValue, bValue, _  = getShaderParameter(part, "dirtColor");
			if rValue <= 0.0 then
				return rValue, gValue, bValue;
			end;
		end;
	end;

end;