﻿----------------------------------------------------------------------------
----Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
---@v1.1.1.1----------------------------------------------------------------
----------------------------------------------------------------------------

source(Utils.getFilename("realDirtColor.lua", g_currentModDirectory));

realDirtColorRegister = {};
realDirtColorRegister.modDirectory = g_currentModDirectory;

local modDesc = loadXMLFile("modDesc", g_currentModDirectory .. "modDesc.xml");
realDirtColorRegister.version = getXMLString(modDesc, "modDesc.version");

function installSpec()
	if g_specializationManager:getSpecializationByName("realDirtColor") == nil then
		if realDirtColor == nil then 
			print("ERROR: unable to find source file 'realDirtColor'");
		else 
			for typeName, typeDef in pairs(g_vehicleTypeManager.vehicleTypes) do
				if typeDef ~= nil and (typeName ~= "locomotive") then 
					local isWashable = false;
					local isAnimated = false;
					for name, spec in pairs(typeDef.specializationsByName) do
						if name == "washable" then 
							isWashable = true;
						elseif name == "animatedVehicle" then 
							isAnimated = true;
						end;
					end;
					if isWashable and isAnimated then
						typeDef.specializationsByName["realDirtColor"] = realDirtColor;
						table.insert(typeDef.specializationNames, "realDirtColor");
						table.insert(typeDef.specializations, realDirtColor);
					end;
				end;
			end;
		end;	
	end;	
end;

function realDirtColorRegister:loadMap()

	local rdcMode, redMapNames = realDirtColor:loadSettings();

	if rdcMode then
		print("Load mod: '"..realDirtColor.title..": Simple Mode' v" .. self.version .. " by: "..realDirtColor.author);
	else
		print("Load mod: '"..realDirtColor.title..": Independent Mode' v" .. self.version .. " by: "..realDirtColor.author);
	end;

	if redMapNames ~= nil and #redMapNames > 0 then
		for _, name in pairs(redMapNames) do
			if string.find(g_currentMission.baseDirectory, name) ~= nil then
				realDirtColor:southernDirt();
			end;
		end;
	end;
	
	--removeModEventListener(realDirtColorRegister); --Version 1.1.1.0's Error
end;

VehicleTypeManager.validateVehicleTypes = Utils.prependedFunction(VehicleTypeManager.validateVehicleTypes, installSpec);

addModEventListener(realDirtColorRegister);